<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClustersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('clusters', function (Blueprint $table) {
            $table->increments('id');
            $table->string('hostname')->unique();
            $table->string('clusterid');
            $table->string('role');
            $table->string('cpuinfo');
            $table->integer('cpus');
            $table->integer('cpucores');
            $table->integer('cpuprocs');
            $table->float('cpuloadavg');
            $table->float('cpuloadavgpp');
            $table->float('cpuutil');
            $table->float('memutil');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('clusters');
    }
}
