<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddSomeFieldsToClustersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('clusters', function (Blueprint $table) {
            $table->string('ipaddress')->after('hostname');
            $table->float('diskutil')->after('memutil');
            $table->integer('containers')->after('diskutil');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('clusters', function (Blueprint $table) {
            $table->dropColumn('containers');
            $table->dropColumn('diskutil');
            $table->dropColumn('ipaddress');
        });
    }
}
