<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddShare3ToShareprofiles extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('shareprofiles', function (Blueprint $table) {
            $table->string('sharename3')->after('use_scvuser2');
            $table->string('sharecomment3')->after('sharename3');
            $table->string('sharemod3')->after('sharecomment3');
            $table->string('sharedom3')->after('sharemod3');
            $table->boolean('read_only3')->after('sharedom3');
            $table->string('shareusr3')->after('read_only3');
            $table->string('sharepwd3')->after('shareusr3');
            $table->boolean('use_scvuser3')->after('sharepwd3');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('shareprofiles', function (Blueprint $table) {
            $table->dropColumn('sharename3');
            $table->dropColumn('sharecomment3');
            $table->dropColumn('sharemod3');
            $table->dropColumn('sharedom3');
            $table->dropColumn('read_only3');
            $table->dropColumn('shareusr3');
            $table->dropColumn('sharepwd3');
            $table->dropColumn('use_scvuser3');
        });
    }
}
