<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateScvflowsTable extends Migration
{
	public function up()
	{
		// アップロードファイル承認用のテーブル
		Schema::create('scvflows', function (Blueprint $table) {
			$table->increments('id');
			$table->string('dl_key');
			$table->string('filename');
			$table->string('comment');
			$table->integer('applicant_id');
			$table->integer('authorizer_id');
			$table->string('why_denied');
			$table->string('replaced_filename');	// 承認者によって置換されたファイルの名前
			$table->string('status');	// waiting | permited | denied
			$table->timestamp('requested_at')->default('0000/00/00 00-00-00');
			$table->timestamp('authorized_at')->default('0000/00/00 00-00-00');
		});
	}

	public function down()
	{
		Schema::dropIfExists('scvflows');
	}
}
