<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateScvflowLogsTable extends Migration
{
	public function up()
	{
		// Scvflowsとの違いは、全てが生文字列であること
		Schema::create('scvflow_logs', function (Blueprint $table) {
			$table->increments('id');
			$table->string('dl_key');
			$table->string('filename');
			$table->string('comment');
			$table->string('applicant');
			$table->string('authorizer');
			$table->string('why_denied');
			$table->string('replaced_filename');
			$table->string('status');
			$table->timestamp('requested_at')->default('0000/00/00 00-00-00');
			$table->timestamp('authorized_at')->default('0000/00/00 00-00-00');
		});
	}

	public function down()
	{
		Schema::dropIfExists('scvflow_logs');
	}
}
