<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddColumnsForScvflowToScvusersTable extends Migration
{
	public function up()
	{
		// 氏名，部署，役職，社員番号，承認権カラムを追加
		Schema::table('scvusers', function (Blueprint $table) {
			$table->string('jpname')->after('name');
			$table->string('department')->after('jpname');
			$table->string('post')->after('department');
			$table->string('employee_id')->after('post');
			$table->string('custom_data1')->after('employee_id');
			$table->string('custom_data2')->after('custom_data1');
			$table->string('custom_data3')->after('custom_data2');
			$table->integer('privilege')->after('custom_data3');
		});
	}

	public function down()
	{
		Schema::table('scvusers', function (Blueprint $table) {
			$table->dropColumn('jpname');
			$table->dropColumn('department');
			$table->dropColumn('post');
			$table->dropColumn('employee_id');
			$table->dropColumn('custom_data1');
			$table->dropColumn('custom_data2');
			$table->dropColumn('custom_data3');
			$table->dropColumn('privilege');
		});
	}
}
