<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRevodesktopsTableAndAddSomeFieldsToClientlogsTable extends Migration
{
    public function up()
    {
        Schema::create('revodesktops', function (Blueprint $table) {
            $table->increments('id');
            $table->string('pcname');
            $table->string('dtname');
            $table->integer('uid');
            $table->string('dtstatus');
            $table->integer('commited_count');
            $table->timestamp('lastcommited_at');
        });
        DB::statement("alter table `revodesktops` change `lastcommited_at` `lastcommited_at` timestamp null default '0000-00-00 00:00:00';");

        Schema::table('clientlogs', function (Blueprint $table) {
            $table->timestamp('ready_at')->after('scvimage');
            $table->timestamp('using_at')->after('ready_at');
            $table->timestamp('deleted_at')->after('using_at');
        });
        DB::statement("alter table `clientlogs` change `ready_at` `ready_at` timestamp null default '0000-00-00 00:00:00';");
        DB::statement("alter table `clientlogs` change `using_at` `using_at` timestamp null default '0000-00-00 00:00:00';");
        DB::statement("alter table `clientlogs` change `deleted_at` `deleted_at` timestamp null default '0000-00-00 00:00:00';");
        // これだけmigrate時に現在時間が格納されてしまう
        \App\Clientlog::query()->update(['ready_at' => '0000-00-00 00:00:00']);
    }

    public function down()
    {
    }
}
