<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBrUpdatePoliciesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('br_update_policies', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->integer('match_type');
            $table->string('match_value');
            $table->date('scheduled_day');
            $table->integer('scheduled_interval');
            $table->integer('scheduled_weekly');
            $table->integer('scheduled_monthly');
            $table->time('scheduled_start_time');
            $table->integer('scheduled_time_period');
            $table->integer('at_event');
            $table->integer('retry');
            $table->string('update_from');
            $table->integer('update_protocol');
            $table->integer('target_application');
            $table->tinyInteger('hide_update_menu');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('br_update_policies');
    }
}
