<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePpuAllReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ppu_all_reports', function (Blueprint $table) {
            $table->increments('id');
            $table->string("organization");
            $table->string("serial_number");
            $table->string("lic_option");
            $table->string("uniq_id");
            $table->tinyInteger("report_type");
            $table->timestamp("since_date")->nullable();
            $table->timestamp("before_date")->nullable();
            $table->string("uniq_users");
            $table->string("uniq_users2");
            $table->string("uniq_users3");
            $table->string("uniq_users4");
            $table->string("uniq_users5");
            $table->string("uniq_users6");
            $table->string("hash")->unique();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ppu_all_reports');
    }
}
