<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddHistoryMaxAgeColumnToFirefoxprofilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('firefoxprofiles', function (Blueprint $table) {
            $table->integer('history_max_age')->after('save_history')->default(30);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('firefoxprofiles', function (Blueprint $table) {
            $table->dropColumn('history_max_age');
        });
    }
}
