<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddAttrsToLdapSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ldap_settings', function (Blueprint $table) {
            $table->string('username_attr')->default('samaccountname')->after('filter');
            $table->string('mail_attr')->default('mail')->after('username_attr');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ldap_settings', function (Blueprint $table) {
            $table->dropColumn('username_attr'); 
            $table->dropColumn('mail_attr'); 
        });
    }
}
