<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddNameSyncedatToSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ldap_settings', function (Blueprint $table) {
            $table->string('name')->default('kerberos')->after('id');
            $table->timestamp('synced_at')->nullable()->before('created_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ldap_settings', function (Blueprint $table) {
            $table->dropColumn('name'); 
            $table->dropColumn('synced_at'); 
        });
    }
}
