<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProxySettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('proxy_settings', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->integer('proxy_type');
            $table->string('proxy_host');
            $table->integer('proxy_port');
            $table->string('http_proxy_host');
            $table->integer('http_proxy_port');
            $table->string('ssl_proxy_host');
            $table->integer('ssl_proxy_port');
            $table->text('proxy_exceptions');
            $table->string('proxy_auto_login');
            $table->string('proxy_script_url');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('proxy_settings');
    }
}
