<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateChromeSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('chrome_settings', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->string('homepage');
            $table->string('startup_page');
            $table->boolean('save_history');
            $table->boolean('save_password');
            $table->boolean('save_cookie');
            $table->boolean('save_bookmark');
            $table->boolean('hide_internal_pages');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('chrome_settings');
    }
}
