<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class AddRelatedOrgToLdapSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ldap_settings', function (Blueprint $table) {
            $table->integer('organization_id')->after('groupid');
        });

        // 既存設定のgroupidに基づいてorganization_idを入れる
        $results = DB::table('ldap_settings')
            ->select('id', 'groupid')
            ->get();
        foreach ($results as $result) {
            $orgId = DB::table('scvgroups')
                ->where('id', $result->groupid)
                ->value('organization_id');
            if (!isset($orgId)) {
                continue;
            }
            DB::table('ldap_settings')
                ->where('id', $result->id)
                ->update([
                    'organization_id' => $orgId,
                ]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ldap_settings', function (Blueprint $table) {
            $table->dropColumn('organization_id');
        });
    }
}
