<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ExtendLdapSettingsPassword extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ldap_settings', function (Blueprint $table) {
            // 160文字のパスワードを暗号化した文字列が入るようpassword列を拡張
            $table->string('password', 512)->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ldap_settings', function (Blueprint $table) {
            $table->string('password', 255)->change();
        });
    }
}
