<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddOptionSettingsToOrganizationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('organizations', function (Blueprint $table) {
            $table->boolean('enable_stz')->default(1)->after('lockout_threshold');
            $table->boolean('enable_vck')->default(1)->after('enable_stz');
            $table->boolean('enable_tck')->default(1)->after('enable_vck');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('organizations', function (Blueprint $table) {
            $table->dropColumn('enable_stz');
            $table->dropColumn('enable_vck');
            $table->dropColumn('enable_tck');
        });
    }
}
