<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddEmployeeAttrsToLdapSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ldap_settings', function (Blueprint $table) {
            $table->string('employee_id_attr')->nullable(true)->after('mail_attr');
            $table->string('jpname_attr')->nullable(true)->after('employee_id_attr');
            $table->string('department_attr')->nullable(true)->after('jpname_attr');
            $table->string('post_attr')->nullable(true)->after('department_attr');
            $table->string('custom_data1_attr')->nullable(true)->after('post_attr');
            $table->string('custom_data2_attr')->nullable(true)->after('custom_data1_attr');
            $table->string('custom_data3_attr')->nullable(true)->after('custom_data2_attr');
            $table->string('comment_attr')->nullable(true)->after('custom_data3_attr');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ldap_settings', function (Blueprint $table) {
            $table->dropColumn('employee_id_attr');
            $table->dropColumn('jpname_attr');
            $table->dropColumn('department_attr');
            $table->dropColumn('post_attr');
            $table->dropColumn('custom_data1_attr');
            $table->dropColumn('custom_data2_attr');
            $table->dropColumn('custom_data3_attr');
            $table->dropColumn('comment_attr');
        });
    }
}
