<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPrivAttrsToLdapSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ldap_settings', function (Blueprint $table) {
            $table->string('privilege_attr')->nullable(true)->after('custom_data3_attr');
            $table->string('flow_group_attr')->nullable(true)->after('privilege_attr');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ldap_settings', function (Blueprint $table) {
            $table->dropColumn('privilege_attr');
            $table->dropColumn('flow_group_attr');
        });
    }
}
