<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateManagedBookmarkTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('managed_bookmarks', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->text('bookmarks');
            $table->timestamps();
        });

        Schema::create('chrome_setting_managed_bookmark', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('chrome_setting_id');
            $table->unsignedInteger('managed_bookmark_id');
            $table->integer('order');

            // $table->foreign('chrome_setting_id')->references('id')->on('chrome_settings')->onDelete('cascade');
            // $table->foreign('managed_bookmark_id')->references('id')->on('managed_bookmarks')->onDelete('cascade');
        });

        Schema::create('edge_setting_managed_bookmark', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('edge_setting_id');
            $table->unsignedInteger('managed_bookmark_id');
            $table->integer('order');

            // $table->foreign('edge_setting_id')->references('id')->on('edge_settings')->onDelete('cascade');
            // $table->foreign('managed_bookmark_id')->references('id')->on('managed_bookmarks')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('managed_bookmarks');
        Schema::dropIfExists('chrome_setting_managed_bookmark');
        Schema::dropIfExists('edge_setting_managed_bookmark');
    }
}
