<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddBookmarkToplevelToChromeEdgeSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('chrome_settings', function (Blueprint $table) {
            $table->string('bookmark_toplevel')->after('enable_xff');
        });

        Schema::table('edge_settings', function (Blueprint $table) {
            $table->string('bookmark_toplevel')->after('enable_xff');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('chrome_settings', function (Blueprint $table) {
            $table->dropColumn('bookmark_toplevel');
        });

        Schema::table('edge_settings', function (Blueprint $table) {
            $table->dropColumn('bookmark_toplevel');
        });
    }
}
