<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPauthAccontToFirefoxprofilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('firefoxprofiles', function (Blueprint $table) {
            $table->smallInteger('pauth_account')->after('pauth_flag')->default(0);
            $table->string('pauth_user')->after('pauth_account');
            $table->string('pauth_pass')->after('pauth_user');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('firefoxprofiles', function (Blueprint $table) {
            $table->dropColumn('pauth_account');
            $table->dropColumn('pauth_user');
            $table->dropColumn('pauth_pass');
        });
    }
}
