<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPauthAccountToEdgeSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('edge_settings', function (Blueprint $table) {
            $table->smallInteger('pauth_account')->after('enable_pauth')->default(0);
            $table->string('pauth_user')->after('pauth_account');
            $table->string('pauth_pass')->after('pauth_user');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('edge_settings', function (Blueprint $table) {
            $table->dropColumn('pauth_account');
            $table->dropColumn('pauth_user');
            $table->dropColumn('pauth_pass');
        });
    }
}
