<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddExtensionVersionToUpdaterlogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('updaterlogs', function (Blueprint $table) {
            $table->string('previous_extension_version')->after('current_chrome_version');
            $table->string('current_extension_version')->after('previous_extension_version');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('updaterlogs', function (Blueprint $table) {
            $table->dropColumn('previous_extension_version');
            $table->dropColumn('current_extension_version');
        });
    }
}
