<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateServerListsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('server_lists', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('organization_id');
            $table->mediumText('forward_match_list');
            $table->mediumText('regexp_list');
            $table->tinyInteger('reverse');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('server_lists');
    }
}
