<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use App\Models\ServerList;

class MigrateServerlistFromTextToDb extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        //既存のテキストのリストからDBに移行
        $file = "/var/www/html/scv/wlist/serverlist.txt";
        $regexp_txt = "";
        $forward_txt = "";
        if(file_exists($file)){
            $list = file_get_contents($file);
            $list = str_replace(["\r\n", "\r"], "\n", $list);
            $forward_section_prefix = '[forward_match]';
            $regexp_section_prefix = '[regexp]';
            $start = strpos($list, $forward_section_prefix);
            if($start !== false){
                $start += strlen($forward_section_prefix) + 1;
            }
            $end = strpos($list, $regexp_section_prefix);
            $forward_txt = substr($list, $start, $end - $start);
            $forward_txt = rtrim($forward_txt);

            $start = strpos($list, $regexp_section_prefix);
            if($start !== false){
                $start += strlen($regexp_section_prefix) + 1;
            }
            $end = strlen($list);
            $regexp_txt = substr($list, $start, $end - $start);
            $regexp_txt = rtrim($regexp_txt);
        }

        $params = [
            'forward_match_list' => $forward_txt,
            'regexp_list' => $regexp_txt,
            'reverse' => 0
        ];
        ServerList::create($params);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
