<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateScvxChromeSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('scvx_chrome_settings', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->integer('organization_id')->default(1);
            $table->string('homepage');
            $table->string('startup_page');
            $table->boolean('save_profile');
            $table->boolean('save_history');
            $table->boolean('save_password');
            $table->boolean('save_cookie');
            $table->boolean('save_bookmark');
            $table->boolean('hide_internal_pages');
            $table->boolean('enable_xff');
            $table->string('bookmark_toplevel');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('scvx_chrome_settings');
    }
}
