<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddProxySettingsForScvxChromeSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('scvx_chrome_settings', function (Blueprint $table) {
            $table->integer('proxy_type')->after('save_bookmark');
            $table->boolean('same_proxy')->after('proxy_type');
            $table->text('http_proxy_host')->after('same_proxy');
            $table->integer('http_proxy_port')->after('http_proxy_host');
            $table->text('ssl_proxy_host')->after('http_proxy_port');
            $table->integer('ssl_proxy_port')->after('ssl_proxy_host');
            $table->text('no_proxy_host')->after('ssl_proxy_port');
            $table->text('proxy_url')->after('no_proxy_host');
            $table->boolean('proxy_auth')->after('proxy_url');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('scvx_chrome_settings', function (Blueprint $table) {
            $table->dropColumn('proxy_type');
            $table->dropColumn('same_proxy');
            $table->dropColumn('http_proxy_host');
            $table->dropColumn('http_proxy_port');
            $table->dropColumn('ssl_proxy_host');
            $table->dropColumn('ssl_proxy_port');
            $table->dropColumn('no_proxy_host');
            $table->dropColumn('proxy_url');
            $table->dropColumn('proxy_auth');
        });
    }
}
