<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeEnableXffToXffFlagForScvxChromeSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('scvx_chrome_settings', function (Blueprint $table) {
            $table->integer('enable_xff')->change();
            $table->renameColumn('enable_xff', 'xff_flag');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('scvx_chrome_settings', function (Blueprint $table) {
            $table->renameColumn('xff_flag', 'enable_xff');
            $table->boolean('enable_xff')->change();
        });
    }
}
