<?php

use Illuminate\Database\Seeder;

class ScvgroupsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        \App\Scvgroup::create([
            'name'          => 'DEFAULT',
            'enable'        => '1',
            'sort'          => '_0',
            'comment'       => 'デフォルトグループ',
            'dayofweek'     => 'SUN,MON,TUE,WED,THU,FRI,SAT',
            'hour'          => '00:00-24:00',
            'applist'       => 'firefox',
            'runmode'       => 'SINGLE',
            'image'         => 'DEFAULT',
            'ena_timeout'   => '1',
            'ena_dayofweek' => '0',
            'ena_hour'      => '0',
            'firefoxsave'   => '0',
            'copypaste'     => '0',
            'speaker'       => '0',
            'microphone'    => '0',
            'print'         => '0',
            'transfer'      => '0',
            'scvcdebug'     => '0',
            'scvpriority'   => 'NORMAL'
        ]);

        \App\Scvgroup::create([
            'name'          => 'ADMIN',
            'enable'        => '1',
            'sort'          => '_1',
            'comment'       => 'システム管理者用グループ',
            'dayofweek'     => 'SUN,MON,TUE,WED,THU,FRI,SAT',
            'hour'          => '00:00-24:00',
            'applist'       => 'firefox',
            'runmode'       => 'SINGLE',
            'image'         => 'DEFAULT',
            'ena_timeout'   => '0',
            'ena_dayofweek' => '0',
            'ena_hour'      => '0',
            'firefoxsave'   => '1',
            'copypaste'     => '1',
            'speaker'       => '1',
            'microphone'    => '1',
            'print'         => '0',
            'transfer'      => '0',
            'scvcdebug'     => '0',
            'scvpriority'   => 'NORMAL'
        ]);

        \App\Scvgroup::create([
            'name'          => 'SCVTEMPLATE',
            'enable'        => '1',
            'sort'          => '_1',
            'comment'       => 'プロファイル作成用グループ',
            'dayofweek'     => 'SUN,MON,TUE,WED,THU,FRI,SAT',
            'hour'          => '00:00-24:00',
            'applist'       => 'firefox',
            'runmode'       => 'SINGLE',
            'image'         => 'DEFAULT',
            'ena_timeout'   => '0',
            'ena_dayofweek' => '0',
            'ena_hour'      => '0',
            'firefoxsave'   => '1',
            'copypaste'     => '1',
            'speaker'       => '1',
            'microphone'    => '1',
            'print'         => '0',
            'transfer'      => '0',
            'scvcdebug'     => '0',
            'scvpriority'   => 'NORMAL'
        ]);
    }
}
