$(function () {
  $('#to_left').on('click', function () {
    move_item('#right_list', '#left_list');
    toggle_example('#right_list', '#left_list');
  });
  $('#to_right').on('click', function () {
    move_item('#left_list', '#right_list');
    toggle_example('#left_list', '#right_list');
  });
  $('form').submit(function () {
    var allowed_apps = [],
        denied_apps = [];
    $('#left_list option').not(':disabled').each(function (i, elm) {
      allowed_apps[i] = elm.value;
    });
    $('#right_list option').not(':disabled').each(function (i, elm) {
      denied_apps[i] = elm.value;
    });
    $('input[name=allowed_apps]').val(allowed_apps);
    $('input[name=denied_apps]').val(denied_apps);
  });
  $('#left_asc').on('click', function () {
    console.log('ho');
    do_sort('#left_list', 'asc');
  });
  $('#left_desc').on('click', function () {
    console.log('ho');
    do_sort('#left_list', 'desc');
  });
  $('#right_asc').on('click', function () {
    console.log('ho');
    do_sort('#right_list', 'asc');
  });
  $('#right_desc').on('click', function () {
    console.log('ho');
    do_sort('#right_list', 'desc');
  });

  var move_item = function move_item(src, dest) {
    $("".concat(src, " option:selected")).each(function () {
      var val = $(this).attr('value');
      $("".concat(dest, " option")).each(function () {
        if ($(this).val() == val) {
          $(this).remove();
          return false;
        }
      });
      $("".concat(dest)).append($(this).clone());
      $(this).remove();
    });
    do_sort(src, 'asc');
    do_sort(dest, 'asc');
  };

  var toggle_example = function toggle_example(src, dest) {
    if ($("".concat(src, " option")).length == 0) {
      $("".concat(src)).append($('<option disabled>').html('なし').val('none'));
    }

    if ($("".concat(dest, " option")).not(':disabled').length != 0) {
      $("".concat(dest, " option")).remove(':disabled');
    }
  };

  function do_sort(src, direction) {
    var item;

    if (direction == 'asc') {
      item = $(src).children().sort(function (a, b) {
        var sortA = a.text;
        var sortB = b.text;

        if (sortA > sortB) {
          return 1;
        } else if (sortA < sortB) {
          return -1;
        } else {
          return 0;
        }
      });
    } else if (direction == 'desc') {
      item = $(src).children().sort(function (a, b) {
        var sortA = a.text;
        var sortB = b.text;

        if (sortA < sortB) {
          return 1;
        } else if (sortA > sortB) {
          return -1;
        } else {
          return 0;
        }
      });
    }

    $(src).append(item);
  }

  $('#add_button').on('click', function () {
    var add_appname = $('input[name="add_appname"]').val();
    var reg = new RegExp(/[\\\/\*\?"<>:|]/g);

    if (add_appname === '' | reg.test(add_appname)) {
      alert('そのアプリ名は登録出来ません');
      $('input[name="add_appname"]').val("");
      return false;
    }

    $('#left_list option').each(function () {
      if ($(this).val() == add_appname) {
        $(this).remove();
        return false;
      }
    });
    $('#left_list').append($('<option>').html(add_appname).val(add_appname));
    $('input[name="add_appname"]').val("");
    toggle_example('', '#left_list');
    do_sort('#left_list', 'asc');
  });
});