//グラフ用オブジェクト
var Line = new Array();
//時間取得
var time_divide_str = document.getElementById('time_divide').title;
var time_divide = time_divide_str.split(',');
//グラフ番号取得
var selected_line = document.getElementById('selected_line').title.split(',');
for (var i = 0; i < selected_line.length; i++){
  //グラフ描画用オブジェクト
  var ChartData;
  //グラフオプション
  var options = {
      //canvasの縦横比を維持しない
      maintainAspectRatio: false,
      //アニメーション設定
      animation : false,
      //レスポンシブ対応
      responsive: true,
      //軸設定
      scales: {
        xAxes: [{//x軸
          display: true,
          stacked: false,
          gridLines: {
            display: true
          }
        }],
        yAxes: [{
          id: "y-axis-1",   // Y軸のID
          type: "linear",   // linear固定 
          position: "left", // どちら側に表示される軸か？
          display: true,
          ticks: {
            beginAtZero: true,
          }
        }]
      },
      //tooltipの表記
      tooltips: {
        titleFontSize: 18,
        bodyFontSize: 16,
        callbacks: {
        }
      }
    };
  //選択されたグラフを判定
  switch(selected_line[i]){
    case '1'://CPU使用率/IO_Wait/メモリ空き率
    //データ取得
    var cpu_idle_str = document.getElementById('cpu_idle').title;
    var io_wait_str = document.getElementById('io_wait').title;
    var mem_freeper_str = document.getElementById('mem_freeper').title;

    var cpu_idle = cpu_idle_str.split(',');
    var io_wait = io_wait_str.split(',');
    var mem_freeper = mem_freeper_str.split(',');

    ChartData = {
      labels : [],
      datasets : [{
       label: "CPU使用率",
       fill: true,
       backgroundColor: "rgba(50,50,255,0.05)",
       borderWidth: 2,
       borderColor: "rgba(50,50,255,1)",
       pointRadius: 0.1,
       pointHoverRadius: 0,
         // pointHoverBackgroundC
         pointHitRadius: 20,
         data: [],
         yAxisID: "y-axis-1"
       },{
         label: "I/O保留率",
         fill: false,
         backgroundColor: "rgba(255,75,0,1)",
         borderWidth: 2,
         borderColor: "rgba(255,75,0,1)",
         pointRadius: 0.1,
         pointHoverRadius: 0,
         // pointHoverBackgroundC
         pointHitRadius: 20,
         data: [],
         yAxisID: "y-axis-1"
       },{
         label: "メモリ空き率",
         fill: true,
         backgroundColor: "rgba(107,255,76,0.1)",
         borderWidth: 2,
         borderColor: "rgba(107,255,76,0.7)",
         pointRadius: 0.1,
         pointHoverRadius: 0,
         // pointHoverBackgroundC
         pointHitRadius: 20,
         data: [],
         yAxisID: "y-axis-1"
       }]
     };
    //データ挿入
    for(var j=0; j<time_divide.length; j++){
      //時間
      ChartData.labels.push(time_divide[j]);
      //アイドル率
      ChartData.datasets[0].data.push(cpu_idle[j]);
      ChartData.datasets[1].data.push(io_wait[j]);
      ChartData.datasets[2].data.push(mem_freeper[j]);
    }
    //オプション変更
    options['scales']['yAxes'][0]['ticks']['stepSize'] = 1;
    options['scales']['yAxes'][0]['ticks']['callback'] = function(value){
      return Math.floor(value*100)/100 + "%";
    };
    options['tooltips']['mode'] = 'label';
    options['tooltips']['callbacks']['label'] = function(tooltipItem, data) {
      return data.datasets[tooltipItem.datasetIndex].label +': ' + tooltipItem.yLabel + "%";
    };
    break;
    case '2'://CPUロードアベレージ
    //データ取得
    var load_average1_str = document.getElementById('load_average1').title;
    var load_average5_str = document.getElementById('load_average5').title;
    var load_average15_str = document.getElementById('load_average15').title;

    var load_average1 = load_average1_str.split(',');
    var load_average5 = load_average5_str.split(',');
    var load_average15 = load_average15_str.split(',');

    ChartData = {
      labels : [],
      datasets: [{
       label: "1分平均",
       fill: true,
       backgroundColor: "rgba(0,255,255,0.4)",
       borderWidth: 2,
       borderColor: "rgba(0,255,255,0.9)",
       pointRadius: 0.1,
       pointHoverRadius: 0,
         // pointHoverBackgroundC
         pointHitRadius: 20,
         data: [],
         yAxisID: "y-axis-1"
       },{
         label: "5分平均",
         fill: true,
         backgroundColor: "rgba(129,61,190,0.3)",
         borderWidth: 2,
         borderColor: "rgba(129,61,190,0.9)",
         pointRadius: 0.1,
         pointHoverRadius: 0,
         pointHitRadius: 20,
         data: [],
         yAxisID: "y-axis-1"
       },{
         label: "15分平均",
         fill: true,
         backgroundColor: "rgba(255,57,96,0.3)",
         borderWidth: 2,
         borderColor: "rgba(255,57,96,0.9)",
         pointRadius: 0.1,
         pointHoverRadius: 0,
         pointHitRadius: 20,
         data: [],
         yAxisID: "y-axis-1"
       }]
     };
    //データ挿入
    for(var j=0; j<time_divide.length; j++){
      //時間
      ChartData.labels.push(time_divide[j]);
      //CPUアベレージ
      ChartData.datasets[0].data.push(load_average1[j]);
      ChartData.datasets[1].data.push(load_average5[j]);
      ChartData.datasets[2].data.push(load_average15[j]);
    }
    //オプション変更
    options['scales']['yAxes'][0]['ticks']['callback'] = function(value){
      return Math.floor(value*100)/100
    };
    options['tooltips']['mode'] = 'label';
    options['tooltips']['callbacks']['label'] = function(tooltipItem, data) {
      return data.datasets[tooltipItem.datasetIndex].label +': ' + tooltipItem.yLabel;
    };
    break;
    case '3'://パケット送受信量
    //データ取得
    var tcp_outsegs_str = document.getElementById('tcp_outsegs').title;
    var tcp_insegs_str = document.getElementById('tcp_insegs').title;

    var tcp_outsegs = tcp_outsegs_str.split(',');
    var tcp_insegs = tcp_insegs_str.split(',');

    ChartData = {
      labels : [],
      datasets: [{
       label: "パケット送信量",
       fill: false,
       backgroundColor: "rgba(255,0,0,1)",
       borderWidth: 2,
       borderColor: "rgba(255,0,0,1)",
       pointRadius: 0.1,
       pointHoverRadius: 0,
       pointHitRadius: 20,
       data: [],
       yAxisID: "y-axis-1"
     },{
       label: "パケット受信量",
       fill: false,
       backgroundColor: "rgba(0,0,255,1)",
       borderWidth: 2,
       borderColor: "rgba(0,0,255,1)",
       pointRadius: 0.1,
       pointHoverRadius: 0,
       pointHitRadius: 20,
       data: [],
       yAxisID: "y-axis-1"
     }]
   };
    //データ挿入
    for(var j=0; j<time_divide.length; j++){
      //時間
      ChartData.labels.push(time_divide[j]);
      //パケット送受信量
      ChartData.datasets[0].data.push(tcp_outsegs[j]);
      ChartData.datasets[1].data.push(tcp_insegs[j]);
    }
    //オプション変更

    options['scales']['yAxes'][0]['ticks']['callback'] = function(value){
      return Math.floor(value*100)/100 + 'kbps';
    };
    options['tooltips']['mode'] = 'label';
    options['tooltips']['callbacks']['label'] = function(tooltipItem, data) {
      return data.datasets[tooltipItem.datasetIndex].label +': ' + tooltipItem.yLabel + 'kbps';
    };
    break;
  }
  //スケール任意設定取得
  if(document.getElementById('scale'+(i+1))){//グラフ１のスケール設定が有効
    options['scales']['yAxes'][0]['ticks']['max'] = Number(document.getElementById('scale'+(i+1)).title.split(',')[0]);
    options['scales']['yAxes'][0]['ticks']['min'] = 0; /*Number(document.getElementById('scale1').title.split(',')[1]);*/
  }
  //グラフ内のデータの最大値を求める
  var maximum_data = Math.max.apply(null, ChartData.datasets[0].data);
  if(ChartData.datasets[1]){
    maximum_data = Math.max.apply(null, [maximum_data,Math.max.apply(null, ChartData.datasets[1].data)]);
  }
  if(ChartData.datasets[2]){
    maximum_data = Math.max.apply(null, [maximum_data,Math.max.apply(null, ChartData.datasets[2].data)]);
  }
  // y軸のラベル数が20より多い場合間引く
  if(maximum_data/*- options['scales']['yAxes'][0]['ticks']['min']*//options['scales']['yAxes'][0]['ticks']['stepSize'] >= 20){
    options['scales']['yAxes'][0]['ticks']['stepSize'] = Math.floor(maximum_data/20);
  }
  if(options['scales']['yAxes'][0]['ticks']['max']/options['scales']['yAxes'][0]['ticks']['stepSize'] >= 20){
    options['scales']['yAxes'][0]['ticks']['stepSize'] = Math.floor(options['scales']['yAxes'][0]['ticks']['max']/20);
  }
  Line[i] = new Chart(document.getElementById("line"+(i+1)).getContext("2d"), {
    type: 'line',
    data: ChartData,
    options: options
  });
  if(selected_line[0] == selected_line[1]){//グラフ１グラフ２が同一の場合
    break;//ループを抜ける
  }
}