$(function (){

  $('#bookmark_setting_pop').attr('data-content', '<small>ユーザに共通のブックマークを登録します。（最大100件）</small>');
  $('#bookmark_title_pop').attr('data-content', '<small>必須項目、50文字まで<br>表示されるブックマーク名を指定します。</small>');
  $('#bookmark_url_pop').attr('data-content', '<small>必須項目<br>ブックマークのURLを指定します。</small>');
  $('#bookmark_placement_pop').attr('data-content', '<small>ブックマークの登録先を指定します。</small>');
  $('#bookmark_folder_pop').attr('data-content', '<small>50文字まで<br>複数のブックマークを同一のフォルダでまとめることが可能です。</small>');

  $('#bookmark_setting_pop').popover({trigger: 'hover', html:true});
  $('#bookmark_title_pop').popover({trigger: 'hover', html:true});
  $('#bookmark_url_pop').popover({trigger: 'hover', html:true});
  $('#bookmark_placement_pop').popover({trigger: 'hover', html:true});
  $('#bookmark_folder_pop').popover({trigger: 'hover', html:true});

  /* ------------------ */
  if(typeof(bookmarks) != 'undefined'){

    function createBookmarkRecord(){
      hidePlace = $('#bookmarks-table').data('hideplace');
      $('#bookmarks-table tbody .bookmark-records').remove();
      bookmarks.forEach((value, index) => {
        var edit = $('<a>', {
          "href": "",
          "class": "text-center",
          "data-toggle": "modal",
          "data-target": "#bookmark-modal",
          "data-backdrop": "static",
          "data-clickbutton": index + 1
        }).html('<span class="glyphicon glyphicon glyphicon-edit" aria-hidden="true"></span>');
        var trash = $('<a>', {
          "href":"",
          "class": "trash-link text-center",
        }).html('<span class="glyphicon glyphicon glyphicon-trash" aria-hidden="true"></span>');
        var tr = $('<tr>', {
          "class": "bookmark-records"
        });
        tr.append($('<td>').html(index + 1));
        tr.append($('<td>').html(value.Title));
        tr.append($('<td>').html(value.URL));
        if (!hidePlace) {
          var placement_text = value.Placement == 'toolbar' ? 'ツールバー' : 'メニュー';
          tr.append($('<td>').html(placement_text));
        }
        tr.append($('<td>').html(value.Folder));
        tr.append($('<td>', {"class": "text-center"}).append(edit));
        tr.append($('<td>', {"class": "text-center"}).append(trash));
        $('#bookmarks-table tbody').append(tr);
      });
    }

    function clearModal(){
      $('#modal-message').text('');
      $('#modal-bookmark-num').text('');
      $('#modal-bookmark-placement').val('menu');
      $('.modal-input').val('');
    }

    function editBookmarkObject(num){
      bookmarks.forEach((value, index) => {
        if(index == num -1){
          value.Title = $('#modal-bookmark-title').val(),
          value.URL = $('#modal-bookmark-url').val(),
          value.Placement = $('#modal-bookmark-placement').val(),
          value.Folder = $('#modal-bookmark-folder').val()
        }
      });
      createBookmarkRecord();
    }

    function appendToBookmarks(){
      bookmarks.push({
        Title: $('#modal-bookmark-title').val(),
        URL: $('#modal-bookmark-url').val(),
        Favicon: '',
        Placement: $('#modal-bookmark-placement').val() || '',
        Folder: $('#modal-bookmark-folder').val()
      });
      createBookmarkRecord();
    }

    function validation(num){
      if(typeof(novalidation) != 'undefined' && novalidation){
        return true;
      }
      var title = $('#modal-bookmark-title').val();
      var url = $('#modal-bookmark-url').val();
      var folder = $('#modal-bookmark-folder').val();

      if(title == '' || url == ''){
        $('#modal-message').text('タイトルとURLは必須項目です').css('color', 'red').hide().fadeIn('fast');
        return false;
      }

      var exists = false;
      for(let i=0; i<bookmarks.length; i++){
        if(bookmarks[i].URL == url && i != num -1){
          exists = true;
          break;
        }
      }
      if(exists){
        $('#modal-message').text('既に登録されたURLです').css('color', 'red').hide().fadeIn('fast');
        return false;
      }

      if(title.length > 50 || folder.length > 50){
        $('#modal-message').text('ブックマーク名、フォルダ名は50文字まで登録可能です').css('color', 'red').hide().fadeIn('fast');
        return false;
      }

      return true;
    }

    //ページ表示時にブックマークのレコード作成
    createBookmarkRecord();

    //modal表示時
    $('#bookmark-modal').on('show.bs.modal', function(event){
      var clickButton = $(event.relatedTarget).data('clickbutton');
      if(clickButton == 'new'){
        $('#bookmark-modal-title').text('ブックマーク追加');
        $('#add_bookmark_button').text('追加');
      }else{
        $('#bookmark-modal-title').text('ブックマーク変更');
        $('#add_bookmark_button').text('変更');
        bookmark = bookmarks[clickButton -1];
        $('#modal-bookmark-num').text($(event.relatedTarget).data('clickbutton'));
        $('#modal-bookmark-title').val(bookmark.Title);
        $('#modal-bookmark-url').val(bookmark.URL);
        $('#modal-bookmark-placement').val(bookmark.Placement);
        $('#modal-bookmark-folder').val(bookmark.Folder);
      }
    });

    //追加、編集ボタン押したとき
    $('#add_bookmark_button').on('click', function(event){
      var num = $('#modal-bookmark-num').text();
      if(!validation(num)) return false;
      if(num){
        editBookmarkObject(num);
      }else{
        appendToBookmarks();
      }
      $('#bookmark-modal').modal('hide');
    });

    //削除ボタン押したとき
    $(document).on('click', ".trash-link", function(event){
      event.preventDefault();
      var tr = $(this).parents('tr');
      var num = tr.children(':first').text();
      var url = bookmarks[num-1].URL;
      if(confirm(`${url} を削除しますか？`)){
        bookmarks.splice(num-1, 1);
        createBookmarkRecord();
      }
    });

    //modal終了時
    $('#bookmark-modal').on('hide.bs.modal', function(event){
      clearModal();
    });

    $('input[type=submit]').on('click',function(){
      $('input[name=bookmarks]').val(JSON.stringify(bookmarks));
    });
  }
  /* ------------------ */

});
