$(function () {

    function resetInputOnUpdate(){
        //hiddenのinputをリセットするために削除
        $('.vpn_settings_input').remove();
        $('#vpn_settings_name li').each(function(){
            $('<input>').attr({
                type: 'hidden',
                name: 'vpn_settings['+$(this).attr('data-vs-id')+']',
                value: $(this).index() + 1,
                class: 'vpn_settings_input'
            }).appendTo('form');
        });
    }

    function isDuplicate(selected){
        //すでに選択したアイテムは追加しない
        var ret = false;
        $('.list-group-item').each(function(index, element){
            var st = selected.text();
            var tt = $(this).text().replace(/(\s+)|(×)/g, '');
            if(st === tt) {
                ret = true;
            }
        });
        return ret;
    }

    $('#vpn_settings_name').sortable({
        containment: $('#vpn_settings_td'),
        update: resetInputOnUpdate
    });

    $('#vpn_settings_select').change(function () {
        var selected = $('#vpn_settings_select option:selected');
        if (selected.text() === '選択してください') {
            return;
        }
        if(isDuplicate(selected)){
            return;
        }
        // if ($('.list-group-item').text().indexOf(selected.text()) > -1) {
        //     return;
        // }
        //セレクトボックスで選択した項目をリストに追加
        $('#vpn_settings_name').append(
            '<li class="list-group-item" data-vs-id="' + selected.val() + '">'
            + selected.text()
            + '<button type="button" class="close vs-remove"><span>×</span></button></li>'
        );
        
        $('<input>').attr({
            type: 'hidden',
            name: 'vpn_settings[' + selected.val() +']',
            value: $('#vpn_settings_name li').length,
            class: 'vpn_settings_input'
          }).appendTo('form');

        //セレクトボックスの選択をリセット
        $('#vpn_settings_select').val('0');
    });

    // 削除ボタンを押された時にリストを削除
    $('body').on('click', '.vs-remove', function () {
        $(this).parent().remove();
        resetInputOnUpdate();
    });

});