$(document).ready(function(){
  //laravelのトークンをセット
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });
  $(".servers").click(function(e){
    //ローディング画面表示
    $('#modal-loading').modal({
      show: true,
      backdrop: 'static'
    });
    //クリックされた要素のip,hostname,roleを取得
    var ip       = $(this).closest('tr').find('td').eq(2).text();
    var hostname = $(this).closest('tr').find('td').eq(1).text();
    var role     = $(this).closest('tr').find('td').eq(3).text();
    $.ajax({
      type:"POST",
      url:"/scvmanager/servers_ajax",
      data:{
        ip:ip,
        hostname:hostname,
        role:role
      },
      timeout: 10000,
      success:function(data,dataType){
        var getData = JSON.parse(data);
        console.log(getData);
        $('#ip').html(getData.ip);
        $('#hostname').html(getData.hostname);
        $('#role').html(getData.role);
        $('#cpu').html(getData.cpu);
        $('#mem').html(getData.mem);
        $('#memused').html(getData.memused);
        $('#discused').html(getData.discused);
        $('#load_avarage').html(getData.load_avarage);
        $('#os_version').html(getData.os_version);
        $('#cpuused_modal').html(getData.cpuused);
        $('#sampleModal').modal('show');
        $('#modal-loading').modal('hide');
      },
      error:function(XMLHttpRequest, textStatus, errorThrown){
        alert('Error : ' + errorThrown);
        $('#modal-loading').modal('hide');
      }
    });
  });

  $.ajax({
    type: "GET",
    url: "/scvmanager/ajax",
    data: {data:"1"},

    // Ajax通信が成功した場合に呼び出されるメソッド
    success: function(data, dataType)
    {
    //successのブロック内は、Ajax通信が成功した場合に呼び出される

    //PHPから返ってきたデータの表示
      $("#cpuused").html($.parseJSON(data).cpu);
    },
    //Ajax通信が失敗した場合に呼び出されるメソッド
    error: function(XMLHttpRequest, textStatus, errorThrown)
    {
    //通常はここでtextStatusやerrorThrownの値を見て処理を切り分けるか、単純に通信に失敗した際の処理を記述します。

    //this;
    //thisは他のコールバック関数同様にAJAX通信時のオプションを示します。

    //エラーメッセージの表示
      //alert('Error : ' + errorThrown);
    }
  });

});
