$(function () {
    // ページ読み込み時にグループリストの絞り込み実行
    $(function() {
        const orgId = $('#select-org').val();
        filterGroups(orgId);
    });

    // 組織選択変更時にグループリストの絞り込み実行
    $('#select-org').change(function() {
        const orgId = $(this).val();
        filterGroups(orgId)
    });

    // グループリストの絞り込み
    function filterGroups(orgId) {
        // 絞り込みと選択状態をリセット
        $('#select-group span option').each(function(index, element) {
            $(element).unwrap();
        });
        $('#select-group option').each(function(index, element) {
            $(element).prop('selected', false);
        });

        // 指定組織IDのグループ以外は隠す
        $('#select-group option').each(function(index, element) {
            const $elm = $(element);
            const elmOrgId = $elm.data('orgid');
            if (elmOrgId != orgId) {
                $elm.wrap('<span>');
            }
        });

        // 表示中のリストに初期選択の項目があれば選択する
        const oldGroupId = $('#select-group').data('old');
        $('#select-group option').each(function(index, element) {
            const $elm = $(element);
            if ($elm.val() == oldGroupId) {
                $elm.prop('selected', true);
            }
        });
    }

});
