$(function () {
  $('#to_left').on('click', function () {
    move_item('#right_list', '#left_list');
    toggle_example('#right_list', '#left_list');
  });
  $('#to_right').on('click', function () {
    move_item('#left_list', '#right_list');
    toggle_example('#left_list', '#right_list');
  });
  $('form').submit(function () {
    var allowed_apps = [],
        denied_apps = [];
    $('#left_list option').not(':disabled').each(function (i, elm) {
      allowed_apps[i] = elm.value;
    });
    $('#right_list option').not(':disabled').each(function (i, elm) {
      denied_apps[i] = elm.value;
    });
    $('input[name=add_paths]').val(allowed_apps);
    $('input[name=delete_paths]').val(denied_apps);
  });
  $('#left_asc').on('click', function () {
    console.log('ho');
    do_sort('#left_list', 'asc');
  });
  $('#left_desc').on('click', function () {
    console.log('ho');
    do_sort('#left_list', 'desc');
  });
  $('#right_asc').on('click', function () {
    console.log('ho');
    do_sort('#right_list', 'asc');
  });
  $('#right_desc').on('click', function () {
    console.log('ho');
    do_sort('#right_list', 'desc');
  });

  var move_item = function move_item(src, dest) {
    $("".concat(src, " option:selected")).each(function () {
      var val = $(this).attr('value');
      $("".concat(dest, " option")).each(function () {
        if ($(this).val() == val) {
          $(this).remove();
          return false;
        }
      });
      $("".concat(dest)).append($(this).clone());
      $(this).remove();
    });
    do_sort(src, 'asc');
    do_sort(dest, 'asc');
  };

  var toggle_example = function toggle_example(src, dest) {
    if ($("".concat(src, " option")).length == 0) {
      $("".concat(src)).append($('<option disabled>').html('なし').val('none'));
    }

    if ($("".concat(dest, " option")).not(':disabled').length != 0) {
      $("".concat(dest, " option")).remove(':disabled');
    }
  };

  function do_sort(src, direction) {
    var item;

    if (direction == 'asc') {
      item = $(src).children().sort(function (a, b) {
        var sortA = a.text;
        var sortB = b.text;

        if (sortA > sortB) {
          return 1;
        } else if (sortA < sortB) {
          return -1;
        } else {
          return 0;
        }
      });
    } else if (direction == 'desc') {
      item = $(src).children().sort(function (a, b) {
        var sortA = a.text;
        var sortB = b.text;

        if (sortA < sortB) {
          return 1;
        } else if (sortA > sortB) {
          return -1;
        } else {
          return 0;
        }
      });
    }

    $(src).append(item);
  }

  $('#add_button').on('click', function () {
    var add_pathname = $('input[name="add_pathname"]').val();
    var reg = new RegExp(/[\/\*\?"<>|]/g);
    var reg2 = new RegExp(/[\\]{2,}/g);
    var reg3 = new RegExp(/^[a-zA-Z]\:.+/g);


    if (add_pathname === '' | reg.test(add_pathname)) {
      alert('そのパス名は登録出来ません');
      $('input[name="add_pathname"]').val("");
      return false;
    } else if(reg2.test(add_pathname) || !reg3.test(add_pathname)) {
      alert('無効な形式です');
      $('input[name="add_pathname"]').val("");
      return false;     
    }

    $('#left_list option').each(function () {
      if ($(this).val() == add_pathname) {
        $(this).remove();
        return false;
      }
    });
    $('#left_list').append($('<option>').html(add_pathname).val(add_pathname));
    $('input[name="add_pathname"]').val("");
    toggle_example('', '#left_list');
    do_sort('#left_list', 'asc');
  });
});