$(function () {
  //非同期通信
  // var $j = jQuery.noConflict();
  $('#Graphform').on('submit', function (event) {
    // 本来のPOSTを打ち消す
    event.preventDefault();
    // 操作対象のフォーム要素を取得
    var $form = $(this);
    // 送信ボタンを取得
    var targetId = "submit-button";
    var target = document.getElementById(targetId);
    //POSTデータ整形
    var data = $form.serialize();//POSTするデータ
    var fraudflg = false;//未入力フラグ
    var confirmmsg = '';
    //スケール任意設定フラグによってデータ形式変更
    if ($("[name=scaleflg1]").prop("checked")) {//グラフ1のスケール任意設定が有効
      if (document.getElementById('scale_max1').value /*&& document.getElementById('scale_min1').value*/ && document.getElementById('scale_max1').value > 0) {//グラフ1のスケール数値が入力されている
        data += "&max1=" + document.getElementById('scale_max1').value /*+ "&min1=" + document.getElementById('scale_min1').value*/;
      } else {//グラフ1のスケール数値が未入力
        fraudflg = true;
        confirmmsg = 'グラフ1のスケール数値が不正です。\nグラフ1のスケールをデフォルト設定で出力しますか？';
      }
    }
    if ($("[name=scaleflg2]").prop("checked")) {//グラフ2のスケール任意設定が有効
      if (document.getElementById('scale_max2').value /*&& document.getElementById('scale_min2').value*/ && document.getElementById('scale_max2').value > 0) {//グラフ2のスケール数値が入力されている
        data += "&max2=" + document.getElementById('scale_max2').value /*+ "&min2=" + document.getElementById('scale_min2').value*/;
      } else {//グラフ2のスケール数値が入力されていてグラフ1の未入力フラグが立っている
        if (fraudflg) {//グラフ1とグラフ2のスケール数値が未入力
          confirmmsg = 'グラフ1とグラフ2のスケール数値が不正です。\nデフォルト設定で出力しますか？';
        } else {//グラフ2のみスケール数値が未入力
          confirmmsg = 'グラフ2のスケール数値が不正です。\nグラフ2のスケールをデフォルト設定で出力しますか？';
        }
      }
    }
    if (confirmmsg) {
      var ret = confirm(confirmmsg);//確認メッセージ出力
      if (ret) {//はいが押下された場合
        if ($("[name=scaleflg1]").prop("checked")) {//グラフ1のスケール任意設定が有効
          if (!document.getElementById('scale_max1').value /*|| !document.getElementById('scale_min1').value*/ || document.getElementById('scale_max1').value <= 0) {//グラフ1が未入力または0以下
            data = data.replace(/&scaleflg1=on/g, "");
          }
        }
        if ($("[name=scaleflg2]").prop("checked")) {//グラフ2のスケール任意設定が有効
          if (!document.getElementById('scale_max2').value /*|| !document.getElementById('scale_min2').value*/ || document.getElementById('scale_max2').value <= 0) {//グラフ2が未入力または0以下
            data = data.replace(/&scaleflg2=on/g, "");
          }
        }
      } else {//いいえが押下された場合処理終了
        return;
      }
    }
    //送信
    $.ajax({
      url: $form.attr('action'),
      type: $form.attr('method'),
      data: data,
      dataType: 'json',

      //送信前
      beforeSend: function (xhr, settings) {
        if (document.getElementById("errormsg")) {
          //エラーメッセージが残っている場合は削除
          var targetId = "errormsg";
          var target = document.getElementById(targetId);
          target.parentNode.removeChild(target);
        }
        // 送信ボタンを取得
        var targetId = "submit-button";
        var target = document.getElementById(targetId);
        //ボタンを無効化し、2重送信を防止
        target.setAttribute('disabled', true);
        //ローディング画面を表示
        $('#modal-loading').modal({
          show: true,
          backdrop: 'static'
        });
      },
      //応答後
      complete: function (xhr, textStatus) {
        // ボタンを有効化し、再送信を許可
        target.removeAttribute('disabled');
        //ローディング画面削除
        $('#modal-loading').modal('hide');
      },
      // 通信成功時の処理
      success: function (result, textStatus, xhr) {
        if (!result.errorflg) {
          //グラフ描画
          runScript(result.selected_line1, result.selected_line2, result);
        } else {
          //エラー表示
          consoleError(result);
        }
      },
      // 通信失敗時の処理
      error: function (xhr, textStatus, error) {
        alert('通信がエラーになりました。');
        //エラー表示用
        console.log("NG:" + xhr);
        console.log("NG:" + textStatus);
        console.log("NG:" + error.message);

       if (xhr.status == 500) {
        document.head.innerHTML = "";
        document.body.innerHTML = xhr.responseText;
        }
      }
    });
  });
  //グラフ生成用関数
  function runScript(selected_line1, selected_line2, result) {
    /*選択されたグラフを配列に整形*/
    var selected_line = [selected_line1, selected_line2];
    /*グラフ表示領域が存在しない場合は作成*/
    if (!document.getElementById("div-line1")) {
      //要素の作成
      var div_line1 = document.createElement('div');
      div_line1.id = "div-line1";
      document.getElementById("wrap").appendChild(div_line1);
    }
    if (!document.getElementById("div-line2")) {
      //要素の作成
      var div_line2 = document.createElement('div');
      div_line2.id = "div-line2";
      document.getElementById("wrap").appendChild(div_line2);
    }
    /*jsへ値を渡すためのdiv要素*/
    var targetId = "div-result";
    var target = document.getElementById(targetId);
    /*前のデータが残っている場合は削除*/
    if (target.firstChild) {
      while (target.firstChild) {
        target.removeChild(target.firstChild);
      }
    }
    /*選択されたグラフ番号をJSONから受け取りdiv要素生成*/
    var selected_line_div = document.createElement("div");
    selected_line_div.id = "selected_line";
    selected_line_div.title = selected_line;
    document.getElementById(targetId).appendChild(selected_line_div);
    for (i = 1; i <= 2; i++) {//グラフ二つ分のデータ取得
      switch (selected_line[i - 1]) {//選択されたグラフを判定
        case '1':
          /*CPU使用率をJSONから受け取りdiv要素生成*/
          var cpu_idle = Object.keys(result.cpu_idle_return).map(function (key) {
            return result.cpu_idle_return[key];
          });
          var cpu_idle_div = document.createElement("div");
          cpu_idle_div.id = "cpu_idle";
          cpu_idle_div.title = cpu_idle;
          document.getElementById(targetId).appendChild(cpu_idle_div);
          /*IO_WaitをJSONから受け取りdiv要素生成*/
          var io_wait = Object.keys(result.io_wait_return).map(function (key) {
            return result.io_wait_return[key];
          });
          var io_wait_div = document.createElement("div");
          io_wait_div.id = "io_wait";
          io_wait_div.title = io_wait;
          document.getElementById(targetId).appendChild(io_wait_div);
          /*メモリ空き率をJSONから受け取りdiv要素生成*/
          var mem_freeper = Object.keys(result.mem_freeper_return).map(function (key) {
            return result.mem_freeper_return[key];
          });
          var mem_freeper_div = document.createElement("div");
          mem_freeper_div.id = "mem_freeper";
          mem_freeper_div.title = mem_freeper;
          document.getElementById(targetId).appendChild(mem_freeper_div);
          break;
        case '2':
          /*CPUロードアベレージ1分をJSONから受け取りdiv要素生成*/
          var load_average1 = Object.keys(result.load_average1_return).map(function (key) {
            return result.load_average1_return[key];
          });
          var load_average1_div = document.createElement("div");
          load_average1_div.id = "load_average1";
          load_average1_div.title = load_average1;
          document.getElementById(targetId).appendChild(load_average1_div);
          /*CPUロードアベレージ5分をJSONから受け取りdiv要素生成*/
          var load_average5 = Object.keys(result.load_average5_return).map(function (key) {
            return result.load_average5_return[key];
          });
          var load_average5_div = document.createElement("div");
          load_average5_div.id = "load_average5";
          load_average5_div.title = load_average5;
          document.getElementById(targetId).appendChild(load_average5_div);
          /*CPUロードアベレージ15分をJSONから受け取りdiv要素生成*/
          var load_average15 = Object.keys(result.load_average15_return).map(function (key) {
            return result.load_average15_return[key];
          });
          var load_average15_div = document.createElement("div");
          load_average15_div.id = "load_average15";
          load_average15_div.title = load_average15;
          document.getElementById(targetId).appendChild(load_average15_div);
          break;
        case '3':
          /*パケット送信量をJSONから受け取りdiv要素生成*/
          var tcp_outsegs = Object.keys(result.tcp_outsegs_return).map(function (key) {
            return result.tcp_outsegs_return[key];
          });
          var tcp_outsegs_div = document.createElement("div");
          tcp_outsegs_div.id = "tcp_outsegs";
          tcp_outsegs_div.title = tcp_outsegs;
          document.getElementById(targetId).appendChild(tcp_outsegs_div);
          /*パケット受信量をJSONから受け取りdiv要素生成*/
          var tcp_insegs = Object.keys(result.tcp_insegs_return).map(function (key) {
            return result.tcp_insegs_return[key];
          });
          var tcp_insegs_div = document.createElement("div");
          tcp_insegs_div.id = "tcp_insegs";
          tcp_insegs_div.title = tcp_insegs;
          document.getElementById(targetId).appendChild(tcp_insegs_div);
          break;
        case '4':
        /*コンテナ数をJSONから受け取りdiv要素生成*/
        /*var containers = Object.keys(result.containers_return).map(function(key) {
            return result.containers_return[key];
        });
        var containers_div = document.createElement("div");
        containers_div.id = "containers";
        containers_div.title = containers;
        document.getElementById(targetId).appendChild($containers_div);
        break;*/
      }
      if (selected_line[0] == selected_line[1]) {//一つ目と二つ目のグラフが同じなら要素を削除してループを抜ける
        $div_line2 = document.getElementById("div-line2");
        $div_line2.parentNode.removeChild($div_line2);
        break;
      }
    }
    /*スケール任意設定数値をJSONから受け取りdiv要素生成*/
    /*var scale =  Object.keys(result.graph_scale_return).map(function(key) {
      return result.graph_scale_return[key];
  });*/
    if (selected_line[0] == selected_line[1]) {//グラフ１グラフ２が同一の場合
      if (result.graph_scale_return.max1/*&&result.graph_scale_return.min1*/) {
        var scale_div1 = document.createElement("div");
        scale_div1.id = "scale1";
        scale_div1.title = result.graph_scale_return.max1;// +','+ result.graph_scale_return.min1;
        document.getElementById(targetId).appendChild(scale_div1);
      }
      if (result.graph_scale_return.max2/*&&result.graph_scale_return.min2*/) {
        var scale_div1 = document.createElement("div");
        scale_div1.id = "scale1";
        scale_div1.title = result.graph_scale_return.max2;//','+ result.graph_scale_return.min2;
        document.getElementById(targetId).appendChild(scale_div1);
      }
    } else {
      if (result.graph_scale_return.max1/*&&result.graph_scale_return.min1*/) {
        var scale_div1 = document.createElement("div");
        scale_div1.id = "scale1";
        scale_div1.title = result.graph_scale_return.max1 /*+','+ result.graph_scale_return.min1*/;
        document.getElementById(targetId).appendChild(scale_div1);
      }
      if (result.graph_scale_return.max2/*&&result.graph_scale_return.min2*/) {
        var scale_div2 = document.createElement("div");
        scale_div2.id = "scale2";
        scale_div2.title = result.graph_scale_return.max2 /*+','+ result.graph_scale_return.min2*/;
        document.getElementById(targetId).appendChild(scale_div2);
      }
    }
    if ((!result.graph_scale_return.max1)/*&&(!result.graph_scale_return.min1)*/ && document.getElementById("scale1")) {//グラフ１のスケール設定がなく、div id="scale1"が存在する場合
      document.getElementById(targetId).removeChild(document.getElementById("scale1"));
    }
    if ((!result.graph_scale_return.max2)/*&&(!result.graph_scale_return.min2)*/ && document.getElementById("scale2")) {//グラフ2のスケール設定がなく、div id="scale2"が存在する場合
      document.getElementById(targetId).removeChild(document.getElementById("scale2"))
    }
    /*区切り時間をJSONから受け取りdiv要素生成*/
    var time_divide = Object.keys(result.time_divide).map(function (key) {
      return result.time_divide[key];
    });
    var time_divide_div = document.createElement("div");
    time_divide_div.id = "time_divide";
    time_divide_div.title = time_divide;
    document.getElementById(targetId).appendChild(time_divide_div);
    /*スクリプトタグ生成*/
    var cs = document.createElement("script");
    cs.type = "text/javascript";
    cs.src = "/js/perfChartDraw.js";
    document.getElementById(targetId).appendChild(cs);
    for (i = 1; i <= 2; i++) {//グラフを2つ描画
      var targetId = "div-line" + i;
      var target = document.getElementById(targetId);
      target.innerHTML = '<div><canvas id="line' + i + '"></canvas></div>';
      if (selected_line[0] 　== 　selected_line[1]) {//一つ目と二つ目のグラフが同じならループを抜ける
        break;
      }
    }
  }
  //エラー表示用関数
  function consoleError(result) {
    /*前のグラフデータが残っている場合は削除*/
    if (document.getElementById("div-line1")) {
      var target = document.getElementById("div-line1");
      target.parentNode.removeChild(target);
    }
    if (document.getElementById("div-line2")) {
      var target = document.getElementById("div-line2");
      target.parentNode.removeChild(target);
    }
    /*前のエラーメッセージが存在するか判定*/
    if (!document.getElementById("errormsg")) {
      //エラーメッセージ表示用領域確保
      var targetId = "form-header";
      var target = document.getElementById(targetId);
      target.innerHTML += '<div id="errormsg"></div>';
    } else {
      //前のエラーメッセージが残っている場合は削除
      var target = document.getElementById("errormsg");
      if (target.firstChild) {
        while (target.firstChild) {
          target.removeChild(target.firstChild);
        }
      }
    }
    /*エラーメッセージ表示*/
    var target = document.getElementById("errormsg");
    target.innerHTML = '<p><FONT color="red">' + result.errormsg + '</FONT></p>';
  }
  //注意書きのpop処理
  $(function () {
    $('#name_pop').popover({ trigger: 'hover', html: true });
  });
  checkflg1 = false;
  var checkbox1 = document.getElementById('scaleflg1');
  checkbox1.addEventListener('change', graphScale(1), true);
  checkflg2 = false;
  var checkbox2 = document.getElementById('scaleflg2');
  checkbox2.addEventListener('change', graphScale(2), true);
  //グラフスケール任意設定用関数
  function graphScale(graph_number) {
    return function (ev) {
      if (graph_number == 1) {
        if (!checkflg1) {
          var span = document.createElement('span');
          span.setAttribute('id', 'max1');
          span.textContent = '縦軸の最大値';
          this.parentNode.parentNode.lastElementChild.appendChild(span);
          //属性を設定
          var input = document.createElement('input');
          input.setAttribute('type', 'number');
          input.setAttribute('name', 'scale_max1');
          input.setAttribute('id', 'scale_max1');
          this.parentNode.parentNode.lastElementChild.lastElementChild.appendChild(input);
          // var div = document.createElement('div');
          // div.setAttribute('id', 'min1');
          // div.textContent = '縦軸の最小値';
          // this.parentNode.appendChild(div);
          // //属性を設定
          // var input = document.createElement('input');
          // input.setAttribute('type', 'number');
          // input.setAttribute('name', 'scale_min1');
          // input.setAttribute('id', 'scale_min1');
          // input.setAttribute('value', '0');
          // this.parentNode.lastElementChild.appendChild(input);
        } else {
          this.parentNode.parentNode.lastElementChild.removeChild(this.parentNode.parentNode.lastElementChild.lastElementChild);
          // this.parentNode.removeChild(this.parentNode.lastElementChild);
        }
        checkflg1 = !checkflg1;
      } else {
        if (!checkflg2) {
          var span = document.createElement('span');
          span.setAttribute('id', 'max2');
          span.textContent = '縦軸の最大値';
          this.parentNode.parentNode.lastElementChild.appendChild(span);
          //属性を設定
          var input = document.createElement('input');
          input.setAttribute('type', 'number');
          input.setAttribute('name', 'scale_max2');
          input.setAttribute('id', 'scale_max2');
          this.parentNode.parentNode.lastElementChild.lastElementChild.appendChild(input);

          // var div = document.createElement('div');
          // div.setAttribute('id', 'min2');
          // div.textContent = '縦軸の最小値';
          // this.parentNode.appendChild(div);
          // //属性を設定
          // var input = document.createElement('input');
          // input.setAttribute('type', 'number');
          // input.setAttribute('name', 'scale_min2');
          // input.setAttribute('id', 'scale_min2');
          // input.setAttribute('value', '0');
          // this.parentNode.lastElementChild.appendChild(input);
        } else {
          this.parentNode.parentNode.lastElementChild.removeChild(this.parentNode.parentNode.lastElementChild.lastElementChild);
          // this.parentNode.removeChild(this.parentNode.lastElementChild);
        }
        checkflg2 = !checkflg2;
      }
    }
  }
});
