// ALLの初期化
refresh_all_weeks_checkbox();
toggle_disable_attr();
toggle_upload();

// ALLがチェックされた
$('[name=all_chk]').on('change', function () {
  $('.weeks :not([name=all_chk])').prop('checked', this.checked);
});

// どれかの曜日がチェックされた
$('.weeks :checkbox:not([name=all_chk])').on('change', function () {
  refresh_all_weeks_checkbox();
});

$('[name=scv_flow').on('change', function() {
  toggle_upload();
});

function toggle_upload() {
  var flow_val = $('[name=scv_flow').val();
  console.log(flow_val);
  if(flow_val == 3 || flow_val == 1){
    $('[name=upload]').prop('checked', true).prop('disabled', true);
  } else {
    $('[name=upload]').prop('disabled', false);
  }
}

// 最初から全ての曜日がチェックされていればAllにチェックを入れる
function refresh_all_weeks_checkbox() {
  var all_chked = get_checked_weeks_cnt() === 7;
  $('[name=all_chk]').prop('checked', all_chked);
}

function check_all_weeks() {
  $('.weeks :checkbox:not([name=all_chk])').prop('checked', true);
  refresh_all_weeks_checkbox();
}

function get_checked_weeks_cnt() {
  return $('.weeks :checkbox:not([name=all_chk]):checked').size();
}

// ウィルスチェックダウンロード選択時はアラートを表示
$('select[name=vck_flag]').change(function () {
  if (!has_vck_dl_flag()) return;
  if (!alert_vck_dl()) $(this).val(0);
});

// 送信前にもアラートを表示
$('form').submit(function () {
  if (has_vck_dl_flag() && !alert_vck_dl()) return false;

  //送信前にdisabledを削除
  $('[name=tck_flag]').prop('disabled', false);
  $('[name=stz_flag]').prop('disabled', false);
  $('[name=stz_dl_flag]').prop('disabled', false);
  return true;
});

//サンドボックス連携が選択されたらstc, tckのダウンロードも有効化
$('[name=tck_stz_dl_flag]').change(function(){
  console.log("tck_stz_dl changed");
  toggle_disable_attr();
});

function has_vck_dl_flag() {
  return $('select[name=vck_flag]').val() == 2;
}

function alert_vck_dl() {
  return window.confirm('ウイルスチェックダウンロードを有効にすると\nファイルからのマルウェア感染リスクを伴います。\n\n本当にこの設定でよろしいでしょうか？\n\n');
}

function toggle_disable_attr(){
  if($('[name=tck_stz_dl_flag]').is(':checked')){
    $('[name=tck_flag]').val('2').prop('disabled', true).css({'color':'#888', 'cursor':'not-allowed'});
    $('[name=stz_flag]').val('1').prop('disabled', true).css({'color':'#888', 'cursor':'not-allowed'});
    $('[name=stz_dl_flag]').prop('checked', true).prop('disabled', true);
    $('[name=stz_dl_flag]').parent().css({'color':'#888', 'cursor':'not-allowed'});
  }else{
    $('[name=tck_flag]').prop('disabled', false).css({'color':'', 'cursor':''});
    $('[name=stz_flag]').prop('disabled', false).css({'color':'', 'cursor':''});
    $('[name=stz_dl_flag]').prop('disabled', false);
    $('[name=stz_dl_flag]').parent().css({'color':'', 'cursor':''});
  }
}
