$(function(){
  $('[name=organization_id]').on('change', function(){
    selectVersion("onChange")
  });
});


$(window).on('load', function(){
  selectVersion("onLoad")
});

function selectVersion(event) {
  if( $('[name=organization_id] option:selected')[0] ){
    const organization_id = $('[name=organization_id] option:selected').val();

    $.ajax({
      url: "/scvx/api/v1/firefoxprofile/organizations",
      type: "POST",
      dataType: 'json',
      data:{
          'organization_id': organization_id
      }
    })
    .done(function(data){
      //select内のoption削除
      $('.firefoxprofile_id option').remove();

      let option = "";
      //接続数のセレクトボックス要素書き換え
      option = $('<option>')
          .text('設定しない')
          .attr('value', 0);
      $('.firefoxprofile_id').append(option);

      if(data.length) {
      	$.each(data, function(id,param){
          option = $('<option>')
              .text(param.name)
              .attr('value', param.id);
          $('.firefoxprofile_id').append(option);
      	});
      }
    })
    .fail(function(ret){
      console.log("failed");
    });
  }
}
