$(function(){
  $('[name=organization_id]').on('change', function(){
    selectScvxChromeSetting("onChange")
  });
});


$(window).on('load', function(){
  selectScvxChromeSetting("onLoad")
});

function selectScvxChromeSetting(event) {
  if( $('[name=organization_id] option:selected')[0] ){
    const organization_id = $('[name=organization_id] option:selected').val();

    $.ajax({
      url: "/scvx/api/v1/scvx_chrome_settings/organizations",
      type: "POST",
      dataType: 'json',
      data:{
          'organization_id': organization_id
      }
    })
    .done(function(data){
      //select内のoption削除
      $('.scvx_chrome_setting_id option').remove();

      let option = "";
      //接続数のセレクトボックス要素書き換え
      option = $('<option>')
          .text('設定しない')
          .attr('value', 0);
      $('.scvx_chrome_setting_id').append(option);

      console.log(data)

      if(data.length) {
      	$.each(data, function(id,param){
          option = $('<option>')
              .text(param.name)
              .attr('value', param.id);
          console.log(`param: ${param}`);
          $('.scvx_chrome_setting_id').append(option);
      	});
      }
    })
    .fail(function(ret){
      console.log("failed");
    });
  }
}
