$(function(){
  $('[name=organization_id]').on('change', function(){
    selectOrganization("onChange")
  });
});


$(window).on('load', function(){
  selectOrganization("onLoad")
});

function selectOrganization(event) {
  if( $('[name=organization_id] option:selected')[0] ){
    const organization_id = $('[name=organization_id] option:selected').val();

    $.ajax({
      url: "/scvx/api/v1/shareprofile/organizations",
      type: "POST",
      dataType: 'json',
      data:{
          'organization_id': organization_id
      }
    })
    .done(function(data){
      //select内のoption削除
      $('.shareprofile_id option').remove();

      let option = "";
      //接続数のセレクトボックス要素書き換え
      option = $('<option>')
          .text('設定しない')
          .attr('value', 0);
      $('.shareprofile_id').append(option);

      if(data.length) {
      	$.each(data, function(id,param){
          option = $('<option>')
              .text(param.shname)
              .attr('value', param.id);
          $('.shareprofile_id').append(option);
      	});
      }
    })
    .fail(function(ret){
      console.log("failed");
    });
  }
}