$(function () {

    function isDuplicate(selected) {
        //すでに選択したアイテムは追加しない
        var ret = false;
        $('.list-group-item').each(function (index, element) {
            var st = selected.text();
            var tt = $(this).text().replace(/(\s+)|(×)/g, '');
            if (st === tt) {
                ret = true;
            }
        });
        return ret;
    }

    /* visonprof */
    $('#to_left').on('click', function () {
        move_item('#right_list', '#left_list');
    });
    $('#to_right').on('click', function () {
        move_item('#left_list', '#right_list');
    });
    $('form').submit(function () {
        var allowed_apps = [],
            denied_apps = [];
        $('#left_list option').each(function (i, elm) {
            allowed_apps[i] = elm.value;
        });
        $('#right_list option').each(function (i, elm) {
            denied_apps[i] = elm.value;
        });
        var joined1 = allowed_apps.join(',');
        var joined2 = denied_apps.join(',');
        $('input[name=allowed_apps]').val(joined1);
        $('input[name=denied_apps]').val(joined2);
    });

    var move_item = function move_item(src, dest) {
        $("".concat(src, " option:selected")).each(function () {
            $("".concat(dest)).append($(this).clone());
            $(this).remove();
        });

        // デスクトップショートカット設定の項目設定
        let tmp_shortcuts = $(".shortcut_settings_input").clone();
        $("#shortcut_settings_select").empty();
        $(".shortcut_settings_input").remove();
        $(".shortcuts").remove();
        $("#shortcut_settings_select").append($('<option>').html("選択してください").val("default"));
        $("#left_list option").clone(false).appendTo("#shortcut_settings_select");


        let enableed_apps = $("#left_list option").map((i, e) => e.value).get();
        tmp_shortcuts
            .filter((i,e) => enableed_apps.includes(e.value))
            .each((i,e) => {
                let appname = e.value;
                $('#shortcut_settings_name').append(
                    '<li class="list-group-item shortcuts" data-vs-id="' + appname + '">'
                    + appname
                    + '<button type="button" class="close vs-remove"><span>×</span></button></li>'
                );

                $('<input>').attr({
                   type: 'hidden',
                   name: 'shortcut_settings[' + ($('.shortcut_settings_input').length + 1) + ']',
                   value: appname,
                   class: 'shortcut_settings_input'
                }).appendTo('form');     
            });
    };

    /* デスクトップショートカット設定 */
    function resetInputOnUpdateForShortcut() {
        $('.shortcut_settings_input').remove();
        $('#shortcut_settings_name li').each(function () {
            $('<input>').attr({
                type: 'hidden',
                name: 'shortcut_settings[' + ($('.shortcut_settings_input').length + 1) + ']',
                value: $(this).attr('data-vs-id'),
                class: 'shortcut_settings_input'
            }).appendTo('form');
        });
    }

    $('#shortcut_settings_select').change(function () {
        var selected = $('#shortcut_settings_select option:selected');
        if (selected.text() === '選択してください') {
            return;
        }
        if (isDuplicate(selected)) {
            return;
        }
        //セレクトボックスで選択した項目をリストに追加
        $('#shortcut_settings_name').append(
            '<li class="list-group-item shortcuts" data-vs-id="' + selected.val()+ '">'
            + selected.text()
            + '<button type="button" class="close vs-remove"><span>×</span></button></li>'
        );

        $('<input>').attr({
            type: 'hidden',
            name: 'shortcut_settings[' + ($('.shortcut_settings_input').length + 1) + ']',
            value: selected.val(),
            class: 'shortcut_settings_input'
        }).appendTo('form');

        //セレクトボックスの選択をリセット
        $('#shortcut_settings_select').val('default');
    });

    // 壁紙選択クリックイベント追加
    $('.revo-clktgt').on('click', function () {
        var wpid = $(this).attr('revo-wp-id');
        $('input[name="wallpaper_id"').val(wpid);
        $('.revo-clktgt').removeClass('revo-wp-box-selected');
        $(this).addClass('revo-wp-box-selected');
    });

    // 壁紙初期選択
    var wpid = $('input[name="wallpaper_id"').val();
    $('.revo-clktgt[revo-wp-id="' + wpid + '"]').addClass('revo-wp-box-selected');
    /* visonprof */

    /* vpn_settings */
    function resetInputOnUpdate() {
        //hiddenのinputをリセットするために削除
        $('.vpn_settings_input').remove();
        $('#vpn_settings_name li').each(function () {
            $('<input>').attr({
                type: 'hidden',
                name: 'vpn_settings[' + $(this).attr('data-vs-id') + ']',
                value: $(this).index() + 1,
                class: 'vpn_settings_input'
            }).appendTo('form');
        });
    }

    //旧VPN設定非表示
    $('.old_vpn_settings').hide();
    $('#old_vpn_settings_link a').click(function(e){
        e.preventDefault();
        $('.old_vpn_settings').toggle('normal');
    });

    $('#vpn_settings_name').sortable({
        containment: $('#vpn_settings_td'),
        update: resetInputOnUpdate
    });

    $('#vpn_settings_select').change(function () {
        var selected = $('#vpn_settings_select option:selected');
        if (selected.text() === '選択してください') {
            return;
        }
        if (isDuplicate(selected)) {
            return;
        }
        // if ($('.list-group-item').text().indexOf(selected.text()) > -1) {
        //     return;
        // }
        //セレクトボックスで選択した項目をリストに追加
        $('#vpn_settings_name').append(
            '<li class="list-group-item" data-vs-id="' + selected.val() + '">'
            + selected.text()
            + '<button type="button" class="close vs-remove"><span>×</span></button></li>'
        );

        $('<input>').attr({
            type: 'hidden',
            name: 'vpn_settings[' + selected.val() + ']',
            value: $('#vpn_settings_name li').length,
            class: 'vpn_settings_input'
        }).appendTo('form');

        //セレクトボックスの選択をリセット
        $('#vpn_settings_select').val('0');
    });

    // 削除ボタンを押された時にリストを削除
    $('body').on('click', '.vs-remove', function () {
        $(this).parent().remove();
        resetInputOnUpdate();
        resetInputOnUpdateForShortcut();
    });
    /* vpn_settings */
});