$(function(){
  var forward_editor,
      regexp_editor,
      modal_editor,
      area_type,
      modal_text;
  var obj = {
      mode: "yaml",
      lineNumbers: true,
      indentUnit: 4
  }
  function createEditor(){
    forward_editor = CodeMirror.fromTextArea(document.getElementById('forward_area'), obj);
    regexp_editor  = CodeMirror.fromTextArea(document.getElementById('regexp_area'), obj);
  }

  createEditor();

  //モーダル表示前処理
  $('#sampleModal').on('show.bs.modal', function(event) {
    $(".modal-content").css({
      "height": $(window).height() - 75,
      "overflow-y": "auto"
    });
    console.log($(window).height());
    $('#modal_editor').css({
      "height" : $(window).height() -235
    });

    if(enable_cm){
      //一旦テキストエリアに戻して再度codemirror呼び出し
      regexp_editor.toTextArea();
      forward_editor.toTextArea();
      createEditor();
    }

    area_type  = $(event.relatedTarget).data('areatype');
    if(area_type == "forward_match"){
      modal_text = $("#forward_area").val();
      $("#title").text("前方一致");
    }else if(area_type == "regexp"){
      modal_text = $("#regexp_area").val();
      $("#title").text("正規表現");
    }
    $("#modal_editor").val(modal_text);

    if(enable_cm){
      modal_editor = CodeMirror.fromTextArea(document.getElementById('modal_editor'), obj);
      modal_editor.setSize(null , $(window).height() -235);

      setTimeout(function(){
        modal_editor.refresh();
      },500);
    }
  });

  //モーダル終了時処理
  $('#sampleModal').on('hide.bs.modal', function(event) {
    if(enable_cm){
      modal_editor.toTextArea();
      regexp_editor.toTextArea();
      forward_editor.toTextArea();
    }
    var edited = $("#modal_editor").val();
    if(area_type == "forward_match"){
      console.log("forward edited");
      $("#forward_area").val(edited);
    }else if(area_type == "regexp"){
      console.log("regexp edited");
      $("#regexp_area").val(edited);
    }
    if(enable_cm){
      createEditor();
    }
  });

  var enable_cm = true;
  $('#switch_btn').on('click', function() {
    if(enable_cm){
      forward_editor.toTextArea();
      regexp_editor.toTextArea();
      enable_cm = false;
    }else{
      createEditor();
      enable_cm = true;
    }
  });

  //正規表現チェッカー
  $('#regexp_btn').on('click', function() {
    var regval = $('#regexp').val();
    var str = $('#string').val();
    if(regval == "" || str == ""){
      $('#result').text('正規表現と文字列を入力してください。');
      return;
    }
    var regexp = new RegExp(regval);
    var ret = regexp.test(str);
    if(ret){
      $('#result').text('一致しました。').hide().fadeIn(200);
    }else{
      $('#result').text('一致しません。').hide().fadeIn(200);
    }
  });
});
