// 期間選択GUI
$('input[name=start_date], input[name=end_date]').datetimepicker({
    format: 'Y-m-d H:i',
    step: 60,       // 時刻を60分刻みで指定
    maxDate: '0',   // 未来選択不可
    //theme: 'dark' // ダークモードになる
});
$.datetimepicker.setLocale('ja');

// 期間選択ボタンなどで後から任意の時間に変更したいとき
function update_datetimepicker(start_date, end_date) {
    var date2fmt = function (date) {
        var ymd = '-', hms = ':', fmt = '';
        fmt += date.getFullYear() + '' + ymd;
        fmt += date.getMonth() + 1 + '' + ymd;
        fmt += date.getDate() + ' ';
        fmt += date.getHours() + hms;
        return fmt + date.getMinutes();
    }
    $('input[name="start_date"]').datetimepicker({ 'value': date2fmt(start_date) });
    $('input[name="end_date"]').datetimepicker({ 'value': date2fmt(end_date) });
}