// 登録、編集時のツールチップに置き換えたり、アスタリスクを付けたり
(function () {

  var map = {
    '#scvuser-name': {
      title: 'ユーザ名に使用可能な文字',
      content: '半角英小文字、数字、アンダースコア、ピリオド、ハイフン（先頭は英数）が使用できます。',
      asterisk: 1
    },
    '#scvuser-password': {
      title: 'パスワードに使用可能な文字',
      content: '半角英数と!$%-=^~@[{+:*]},./?_#が使用できます。',
      asterisk: 1
    },
    '#scvuser-password-confirmation': {
      title: null,
      content: null,
      asterisk: 1
    },
    '#scvuser-email': {
      title: '通知用メールアドレス',
      content: 'SCV Flow有効時は、メールアドレスは必須項目となります。',
      asterisk: 0
    },
    '#scvuser-flows': {
      title: '社員番号, 氏名, 部署, 役職, 任意データ',
      content: 'スペースを除く全角文字と半角英数と.-_が使用できます。',
      asterisk: 0
    },
    '#ldapsetting-name': {
      title: 'LDAP設定名',
      content: '半角英数と-_が使用できます。先頭は半角英数が使用できます。',
      asterisk: 1
    },
    '#ldapsetting-host': {
      title: null,
      content: null,
      asterisk: 1
    },
    '#ldapsetting-dn': {
      title: null,
      content: null,
      asterisk: 1
    },
    '#ldapsetting-filter': {
      title: 'フィルター',
      content: 'LDAP検索時の検索条件を記述します。省略した場合 (cn=*) が適用されます。',
      asterisk: 0
    },
    '#ldapsetting-usernameattr': {
      title: 'ユーザ名属性',
      content: 'インポート時にSCVユーザ名とする値のLDAP属性名を指定します。省略した場合 sAMAccountName が適用されます。',
      asterisk: 0
    },
    '#ldapsetting-privilegeattr': {
      title: 'SCV Flow承認権限属性',
      content: 'SCV Flow承認権限の有無を示すLDAP属性名を指定します。LDAPエントリが指定属性に何らかの値を持つ場合、ユーザの承認権限が有効となります。',
      asterisk: 0
    },
    '#scvgroup-name': {
      title: 'グループ名に使用可能な文字',
      content: '半角英大文字、数字、アンダースコア、ピリオド、ハイフン（先頭は英数）が使用できます。',
      asterisk: 1
    },
    '#scvgroup-copypaste': {
      title: 'コピー＆ペーストの禁止',
      content: '無効：コピー＆ペーストを禁止<br>上下有効：双方向でのコピー＆ペーストを許可<br>上り有効：ローカルからコンテナへのコピー＆ペーストを許可<br>下り有効：コンテナからローカルへのコピー＆ペーストを許可',
      asterisk: 0
    },
    '#organization-name': {
      title: '組織名に使用可能な文字',
      content: '半角英大文字、数字、アンダースコア、ピリオド、ハイフン（先頭は英数）が使用できます。',
      asterisk: 1
    },
    '#organization-max-limit': {
      title: '最大接続数',
      content: '-1で無制限になります。',
      asterisk: 0
    },
    '#organization-authentication': {
      title: '認証方式（未実装）',
      //content: '.scvconfにてscvxsaml認証が有効になっている場合は、組織毎の認証方式の切り替えはできません。<br>「なし」に設定すると、常にSCV_AUTHENTICATIONの値を参照します。',
      content: '組織毎に認証方式を設定します。',
      asterisk: 0
    },
    '#organization-pwdpolicy-length': {
      title: 'パスワードの最低文字数',
      content: 'これを下回る文字数のパスワードは設定できないようになります（最低1文字）',
      asterisk: 0
    },
    '#organization-pwdpolicy-min-term': {
      title: 'パスワード変更の最低間隔',
      content: 'パスワードを変更したときに、次にパスワード変更ができるようになるまでの日数を設定します（0で常に変更可能）',
      asterisk: 0
    },
    '#organization-pwdpolicy-max-term': {
      title: 'パスワードの有効期限',
      content: 'パスワードの有効期限を日数で設定します（0で有効期限なし）',
      asterisk: 0
    },
    '#organization-pwdpolicy-warning-term': {
      title: '期限切れ警告の表示期間',
      content: 'パスワード有効期限切れの何日前から警告を表示するかを設定します（0で警告表示なし）<br><br>※「パスワードの有効期限」が0の場合は警告は表示されません。また、「パスワードの有効期限」を超える値が入力された場合、常に警告を表示します',
      asterisk: 0
    },
    '#organization-pwdpolicy-generation-limit': {
      title: '重複チェックを行う世代数',
      content: '過去何件分のパスワードを履歴に残すかを設定します。この期間中に設定したパスワードと同じパスワードは設定できないようになります（0で重複チェックなし）',
      asterisk: 0
    },
    '#organization-pwdpolicy-complexity': {
      title: '一定の複雑性を満たしたパスワードのみ許可する',
      content: '以下を満たしたパスワードのみ設定可能になります。<br>・ユーザ名に含まれる3文字以上連続した文字列が存在しない<br>・大文字、小文字、数字、記号のうち3種類以上が使用されている<br>・長さが6文字以上あること',
      asterisk: 0
    },
    '#organization-pwdpolicy-ngwords': {
      title: 'パスワードに含めることのできない単語',
      content: '改行区切りで文字列を入力すると、それを含むパスワードは設定できなくなります。',
      asterisk: 0
    },
    '#visionprof-vpn-ipaddr': {
      title: 'VPNサーバのIPアドレス',
      content: 'IPアドレス の形式で入力してください',
      asterisk: 0
    },
    '#visionprof-global-vpn-ipaddr': {
      title: 'VPNサーバのIPアドレス(外部)',
      content: 'IPアドレス:ポート番号 の形式で入力してください',
      asterisk: 0
    },
    '#visionprof-volume-size': {
      title: 'デスクトップのボリュームサイズ',
      content: '{min}~{max}MBの範囲で入力してください',
      asterisk: 0
    },
    '#organization-lockhout_threshold': {
      title: 'アカウントロックしきい値',
      content: 'アカウントロックまでの認証の回数を指定します。<br>指定した回数を超えてログイン失敗をするとアカウントがロックされます。'
    },
    '#offline-cache-expiration': {
      title: 'オフライン起動有効期限',
      content: 'オフライン起動時の有効期限を設定します。<br>0の場合はオフライン起動を許可しません。',
      asterisk: 0
    },
    '#run-mode': {
      title: '実行モード',
      content: 'RevoBrowserを利用する場合SINGLEモードを選択してください。',
      asterisk: 0
    },
    '#ieprofile-name-tooltip' :{
      title: 'IE設定名',
      content: '設定名に使用可能な文字は半角英数と-._です。',
      asterisk: 1
    },
    '#adminpolicy-length': {
      title: 'パスワードの最低文字数',
      content: 'これを下回る文字数のパスワードは設定できないようになります（最低1文字）',
      asterisk: 0
    },
    '#adminpolicy-min-term': {
      title: 'パスワード変更の最低間隔',
      content: 'パスワードを変更したときに、次にパスワード変更ができるようになるまでの日数を設定します（0で常に変更可能）',
      asterisk: 0
    },
    '#adminpolicy-max-term': {
      title: 'パスワードの有効期限',
      content: 'パスワードの有効期限を日数で設定します（0で有効期限なし）',
      asterisk: 0
    },
    '#adminpolicy-warning-term': {
      title: '期限切れ警告の表示期間',
      content: 'パスワード有効期限切れの何日前から警告を表示するかを設定します（0で警告表示なし）<br><br>※「パスワードの有効期限」が0の場合は警告は表示されません。また、「パスワードの有効期限」を超える値が入力された場合、常に警告を表示します',
      asterisk: 0
    },
    '#adminpolicy-generation-limit': {
      title: '重複チェックを行う世代数',
      content: '過去何件分のパスワードを履歴に残すかを設定します。この期間中に設定したパスワードと同じパスワードは設定できないようになります（0で重複チェックなし）',
      asterisk: 0
    },
    '#adminpolicy-complexity': {
      title: '一定の複雑性を満たしたパスワードのみ許可する',
      content: '以下を満たしたパスワードのみ設定可能になります。<br>・ユーザ名に含まれる3文字以上連続した文字列が存在しない<br>・大文字、小文字、数字、記号のうち3種類以上が使用されている<br>・長さが6文字以上あること',
      asterisk: 0
    },
    '#adminpolicy-ngwords': {
      title: 'パスワードに含めることのできない単語',
      content: '改行区切りで文字列を入力すると、それを含むパスワードは設定できなくなります。',
      asterisk: 0
    },
    '#adminpolicy-lock-limit': {
      title: 'アカウントロックまでのログイン試行回数',
      content: '設定された回数分連続してパスワードを間違えた場合、そのアカウントをロックするようになります。',
      asterisk: 0
    },
    '#flow_authorizer': {
      title: null,
      content: null,
      asterisk: 1
    },
    '#allowed-hosts-tooltip': {
      title: '許可ホスト',
      content: 'IPアドレスもしくはCIDR形式で入力できます。<br>複数入力する場合は改行で区切ってください。',
      asterisk: 0
    },
    '#vpn-settings-tooltip': {
      title: 'VPN設定',
      content: '利用するVPN設定を選択します（複数選択可）<br>ドラッグ＆ドロップで順番の入れ替えが可能です。<br>評価基準はクライアントのバージョンによって異なります。'
    },
    '#old-vpn-settings-tooltip': {
      title: '旧VPN設定',
      content: 'RevoDesktop2.1.46以前のクライアントを利用する場合はこちらに設定してください。'
    },
    '#create-shortcut-tooltip': {
      title: 'ショートカット作成',
      content: '有効の場合、RevoWorks Desktop起動時にアプリケーションショートカットを自動的に作成します。'
    },
    '#shortcut-settings-tooltip': {
      title: 'デスクトップショートカット設定',
      content: 'RevoWorks Desktop起動時に選択されたアプリのショートカットを自動的に作成します。'
    }
  };

  for (var key in map) {
    var title    = map[key].title;
    var content  = '<small>' + map[key].content + '</small>';
    var asterisk = map[key].asterisk;
    if (title !== null) {
      if (typeof tooltipParameters !== 'undefined') {
        content = formatContent(key, content, tooltipParameters);
      }
      init_as_tooltip(key, title, content);
    }
    if (asterisk) add_asterisk_after_th(key);
  }

  if (typeof flow_available === 'undefined')
    flow_available = false;

  if (flow_available)
    add_asterisk_after_th('#scvuser-email');

})();

function init_as_tooltip(selector, title, content) {
  var elm = $(selector);
  elm.addClass('glyphicon glyphicon-question-sign text-info');
  elm.attr('title', title);
  elm.attr('data-content', '<small>' + content + '</small>');
  elm.popover({ trigger: 'hover', html: true });
}

function add_asterisk_after_th(selector) {
  $(selector).parent().prev().append(' <span style="color: red">*</span>');
}

function formatContent(key, content, paramses) {
  var params = paramses[key];
  if (params == null) {
    return content;
  }

  for (var key in params) {
    var placeholder = '{' + key + '}';
    content = content.replaceAll(placeholder, params[key]);
  }
  return content;
}