//グラフ用オブジェクト
var Line = new Array();
//時間取得
var time_divide_str = document.getElementById('time_divide').title;
var time_divide = time_divide_str.split(',');
//グラフ番号取得
var selected_line = document.getElementById('selected_line').title.split(',');
for (var i = 0; i < selected_line.length; i++){
  //グラフ描画用オブジェクト
  var ChartData = {
    datasets : [{
      borderWidth: 1.8,
      pointRadius: 2,
      pointBorderWidth: 0,
      pointHoverRadius: 2.5,
      pointHoverBorderWidth: 5,
      pointHitRadius: 20,
    }]
  };
  //グラフオプション
  var options = {
      //canvasの縦横比を維持しない
      maintainAspectRatio: false,
      //アニメーション設定
      animation : false,
      //レスポンシブ対応
      responsive: true,
      //軸設定
      scales: {
        xAxes: [{//x軸
          display: true,
          stacked: false,
          gridLines: {
            display: true
          }
        }],
        yAxes: [{
          id: "y-axis-1",   // Y軸のID
          type: "linear",   // linear固定 
          position: "left", // どちら側に表示される軸か？
          display: true,
          ticks: {
            beginAtZero: true,
          }
        }]
      },
      //tooltipの表記
      tooltips: {
        titleFontSize: 18,
        bodyFontSize: 16,
        callbacks: {
        }
      }
    };
  //選択されたグラフを判定
  switch(selected_line[i]){
    case '1'://最大同時接続数
      //データ取得
      var max_user_str = document.getElementById('max_user').title;

      var max_user = max_user_str.split(',');
      ChartData = {
        labels : [],
        datasets : [{
         label: "最大同時接続数",
         fill: false,
         backgroundColor: "rgba(60,179,113,1)",
           //borderWidth: 2,
           borderColor: "rgba(60,179,113,0.8)",
           //pointRadius: 2.5,
           //pointBorderColor: "#fff",
           pointBackgroundColor: "rgba(60,179,113,1)",
           //pointBorderWidth: 2,
           //pointHoverRadius: 3,
           pointHoverBackgroundColor: "rgba(60,179,113,1)",
           pointHoverBorderColor: "#fff",
           //pointHoverBorderWidth: 0.5,
           tension: 0,
           //pointHitRadius: 20,
           data: [],
           yAxisID: "y-axis-1"
         }]
       };
      //データ挿入
      for(var j=0; j<time_divide.length; j++){
        //時間
        ChartData.labels.push(time_divide[j]);
        //最大同時接続数
        ChartData.datasets[0].data.push(max_user[j]);
      }
        //オプション変更
        options['scales']['yAxes'][0]['ticks']['stepSize'] = 1;
        options['scales']['yAxes'][0]['ticks']['callback'] = function(value){
          return value;};
          options['tooltips']['mode'] = 'single';
          options['tooltips']['callbacks']['label'] = function(tooltipItem, data) {
            return data.datasets[tooltipItem.datasetIndex].label +': ' + tooltipItem.yLabel;
          };
          break;
      case '2'://総ログイン回数（失敗含む）/ログイン成功回数
      //データ取得
      var login_success_str = document.getElementById('login_success').title;
      var login_times_str = document.getElementById('login_times').title;
      var time_divide_str = document.getElementById('time_divide').title;
      var login_success = login_success_str.split(',');
      var login_times = login_times_str.split(',');
      var time_divide = time_divide_str.split(',');

      ChartData = {
        labels : [],
        datasets: [{
          label: "ログイン成功回数",
          fill: false,
          backgroundColor: "rgba(84,77,203,1)",
          //borderWidth: 2,
          borderColor: "rgba(84,77,203,0.5)",
          //pointRadius: 2.5,
          //pointBorderColor: "#fff",
          pointBackgroundColor: "rgba(84,77,203,1)",
          //pointBorderWidth: 2,
          //pointHoverRadius: 3,
          pointHoverBackgroundColor: "rgba(84,77,203,1)",
          pointHoverBorderColor: "#fff",
          //pointHoverBorderWidth: 0.5,
          tension: 0,
          //pointHitRadius: 20,
          data: [],
          yAxisID: "y-axis-1"
        },{
          label: "総ログイン回数（失敗含む）",
          fill: false,
          backgroundColor: "rgba(0,191,255,1)",
          //borderWidth: 2,
          borderColor: "rgba(0,191,255,1)",
          //pointRadius: 2.5,
          //pointBorderColor: "#fff",
          pointBackgroundColor: "rgba(0,191,255,0.3)",
          //pointBorderWidth: 2,
          //pointHoverRadius: 3,
          pointHoverBackgroundColor: "rgba(0,191,255,1)",
          pointHoverBorderColor: "#fff",
          //pointHoverBorderWidth: 0.5,
          tension: 0,
          //pointHitRadius: 20,
          data: [],
          yAxisID: "y-axis-1"
        }]
      };
      //データ挿入
      for(var j=0; j<time_divide.length; j++){
        //時間
        ChartData.labels.push(time_divide[j]);
        //ログイン成功回数
        ChartData.datasets[0].data.push(login_success[j]);
        //総ログイン回数
        ChartData.datasets[1].data.push(login_times[j]);
      }
      //オプション変更
      options['scales']['yAxes'][0]['ticks']['stepSize'] = 1;
      options['scales']['yAxes'][0]['ticks']['callback'] = function(value){
        return value+'回';
      };
      options['tooltips']['mode'] = 'label';
      options['tooltips']['callbacks']['label'] = function(tooltipItem, data) {
        return data.datasets[tooltipItem.datasetIndex].label +': ' + tooltipItem.yLabel + ' 回';
      　};
      break;
    case '3'://平均クライアント起動時間
      //データ取得
      var average_startuptime_str = document.getElementById('average_startuptime').title;

      var average_startuptime = average_startuptime_str.split(',');
      ChartData = {
        labels : [],
        datasets: [{
         label: "クライアント起動時間平均",
         fill: false,
         backgroundColor: "rgba(239,117,188,1)",
           //borderWidth: 2,
           borderColor: "rgba(239,117,188,0.5)",
           //pointRadius: 2.5
           //pointBorderColor: "#fff",
           pointBackgroundColor: "rgba(239,117,188,1)",
           //pointBorderWidth: 2,
           //pointHoverRadius: 5,
           pointHoverBackgroundColor: "rgba(239,117,188,1)",
           pointHoverBorderColor: "#fff",
           //pointHoverBorderWidth: 2,
           tension: 0,
           data: [],
           yAxisID: "y-axis-1"
         }]
       };
      //データ挿入
      for(var j=0; j<time_divide.length; j++){
        //時間
        ChartData.labels.push(time_divide[j]);
        //パケット送受信量
        ChartData.datasets[0].data.push(average_startuptime[j]);
      }
      //オプション変更
      options['scales']['yAxes'][0]['ticks']['stepSize'] = 0.5;
      options['scales']['yAxes'][0]['ticks']['callback'] = function(value){
        return Math.floor(value*10)/10+'秒';
      };
      options['tooltips']['mode'] = 'single';
      options['tooltips']['callbacks']['label'] = function(tooltipItem, data) {
        return data.datasets[tooltipItem.datasetIndex].label +': ' + tooltipItem.yLabel + ' 秒';
      　};
      break;
    case '4'://平均利用時間
      //データ取得
      var average_utillization_str = document.getElementById('average_utillization').title;

      var average_utillization = average_utillization_str.split(',');
      ChartData = {
        labels : [],
        datasets: [{
         label: "平均利用時間",
         fill: false,
         backgroundColor: "rgba(34,139,34,1)",
           //borderWidth: 2,
           borderColor: "rgba(34,139,34,0.5)",
           //pointBorderColor: "#fff",
           pointBackgroundColor: "rgba(34,139,34,1)",
           //pointBorderWidth: 2,
           //pointHoverRadius: 5,
           pointHoverBackgroundColor: "rgba(34,139,34,1)",
           pointHoverBorderColor: "#fff",
           //pointHoverBorderWidth: 2,
           tension: 0,
           data: [],
           yAxisID: "y-axis-1"
         }]
       };
      //データ挿入
      for(j=0; j<time_divide.length; j++){
        //時間
        ChartData.labels.push(time_divide[j]);
        //平均利用時間
        ChartData.datasets[0].data.push(average_utillization[j]);
      }
      //オプション変更
      options['scales']['yAxes'][0]['ticks']['stepSize'] = 1;
      options['scales']['yAxes'][0]['ticks']['callback'] = function(value){
        return value + '分';
      };
      options['tooltips']['mode'] = 'single';
      options['tooltips']['callbacks']['label'] = function(tooltipItem, data) {
        return data.datasets[tooltipItem.datasetIndex].label +': ' + tooltipItem.yLabel + '分';
      　};
      break;
    case '5'://エラー回数
      //データ取得
      var all_error_str = document.getElementById('all_error').title;
      var docker_duplicated_error_str = document.getElementById('docker_duplicated_error').title;

      var all_error_times = all_error_str.split(',');
      var docker_duplicated_error_times = docker_duplicated_error_str.split(',');
      ChartData = { 
        labels : [],
        datasets: [{
         label: "重複エラー回数",
         fill: false,
         backgroundColor: "rgba(34,139,34,1)",
           //borderWidth: 2,
           borderColor: "rgba(34,139,34,0.5)",
           //pointBorderColor: "#fff",
           pointBackgroundColor: "rgba(34,139,34,1)",
           //pointBorderWidth: 2,
           //pointHoverRadius: 5,
           pointHoverBackgroundColor: "rgba(34,139,34,1)",
           pointHoverBorderColor: "#fff",
           //pointHoverBorderWidth: 2,
           tension: 0,
           data: [],
           yAxisID: "y-axis-1"
         },{
           label: "エラー総数",
           fill: false,
           backgroundColor: "rgba(72,209,204,1)",
           //borderWidth: 2,
           borderColor: "rgba(72,209,204,0.3)",
           //pointBorderColor: "#fff",
           pointBackgroundColor: "rgba(72,209,204,1)",
           //pointBorderWidth: 2,
           //pointHoverRadius: 5,
           pointHoverBackgroundColor: "rgba(72,209,204,1)",
           pointHoverBorderColor: "#fff",
           //pointHoverBorderWidth: 2,
           tension: 0,
           data: [],
           yAxisID: "y-axis-1"
         }]
       };
      //データ挿入
      for(var j=0; j<time_divide.length; j++){
        //時間
        ChartData.labels.push(time_divide[j]);
        //重複エラー回数
        ChartData.datasets[0].data.push(docker_duplicated_error_times[j]);
        //その他エラー回数
        ChartData.datasets[1].data.push(all_error_times[j]);
      }
      //オプション変更
      options['scales']['yAxes'][0]['ticks']['stepSize'] = 1;
      options['scales']['yAxes'][0]['ticks']['callback'] = function(value){
        return value + '回';
      };
      options['tooltips']['mode'] = 'label';
      options['tooltips']['callbacks']['label'] = function(tooltipItem, data) {
        return data.datasets[tooltipItem.datasetIndex].label +': ' + tooltipItem.yLabel + ' 回';
      　};
      break;
    case '6'://エラー率
      //データ取得
      var all_error_rate_str = document.getElementById('all_error_rate').title;
      var docker_duplicated_error_rate_str = document.getElementById('docker_duplicated_error_rate').title;

      var all_error_rate = all_error_rate_str.split(',');
      var docker_duplicated_error_rate = docker_duplicated_error_rate_str.split(',');
      ChartData = {
        labels : [],
        datasets: [{
         label: "重複エラー率",
         fill: false,
         backgroundColor: "rgba(34,139,34,1)",
           //borderWidth: 2,
           borderColor: "rgba(34,139,34,0.5)",
           //pointBorderColor: "#fff",
           pointBackgroundColor: "rgba(34,139,34,1)",
           //pointBorderWidth: 2,
           //pointHoverRadius: 5,
           pointHoverBackgroundColor: "rgba(34,139,34,1)",
           pointHoverBorderColor: "#fff",
           //pointHoverBorderWidth: 2,
           tension: 0,
           data: [],
           yAxisID: "y-axis-1"
         },{
           label: "エラー率",
           fill: false,
           backgroundColor: "rgba(72,209,204,1)",
           //borderWidth: 2,
           borderColor: "rgba(72,209,204,0.3)",
           //pointBorderColor: "#fff",
           pointBackgroundColor: "rgba(72,209,204,1)",
           //pointBorderWidth: 2,
           //pointHoverRadius: 5,
           pointHoverBackgroundColor: "rgba(72,209,204,1)",
           pointHoverBorderColor: "#fff",
           //pointHoverBorderWidth: 2,
           tension: 0,
           data: [],
           yAxisID: "y-axis-1"
         }]
       };
      //データ挿入
      for(var j=0; j<time_divide.length; j++){
        //時間
        ChartData.labels.push(time_divide[j]);
        //重複エラー回数
        ChartData.datasets[0].data.push(docker_duplicated_error_rate[j]);
        //その他エラー回数
        ChartData.datasets[1].data.push(all_error_rate[j]);
      }
      //オプション変更
      options['scales']['yAxes'][0]['ticks']['stepSize'] = 1;
      options['scales']['yAxes'][0]['ticks']['callback'] = function(value){
        return value+'%';
      };
      options['tooltips']['mode'] = 'label';
      options['tooltips']['callbacks']['label'] = function(tooltipItem, data) {
        return data.datasets[tooltipItem.datasetIndex].label +': ' + tooltipItem.yLabel + ' %';
      　};
      break;
    }
  //スケール任意設定取得
  if(document.getElementById('scale'+(i+1))){//グラフiのスケール設定が有効
    options['scales']['yAxes'][0]['ticks']['max'] = Number(document.getElementById('scale'+(i+1)).title.split(',')[0]);
    options['scales']['yAxes'][0]['ticks']['min'] = 0; /*Number(document.getElementById('scale1').title.split(',')[1]);*/
  }
  //グラフ内のデータの最大値を求める
  var maximum_data = Math.max.apply(null, ChartData.datasets[0].data);
  if(ChartData.datasets[1]){
    maximum_data = Math.max.apply(null, [maximum_data,Math.max.apply(null, ChartData.datasets[1].data)]);
  }
  if(ChartData.datasets[2]){
    maximum_data = Math.max.apply(null, [maximum_data,Math.max.apply(null, ChartData.datasets[2].data)]);
  }
  // y軸のラベル数が20より多い場合間引く
  if(maximum_data/*- options['scales']['yAxes'][0]['ticks']['min']*//options['scales']['yAxes'][0]['ticks']['stepSize'] >= 20){
    options['scales']['yAxes'][0]['ticks']['stepSize'] = Math.floor(maximum_data/20);
  }
  if(options['scales']['yAxes'][0]['ticks']['max']/options['scales']['yAxes'][0]['ticks']['stepSize'] >= 20){
    options['scales']['yAxes'][0]['ticks']['stepSize'] = Math.floor(options['scales']['yAxes'][0]['ticks']['max']/20);
  }
  Line[i] = new Chart(document.getElementById("line"+(i+1)).getContext("2d"), {
    type: 'line',
    data: ChartData,
    options: options
  });
  if(selected_line[0] == selected_line[1]){//グラフ１グラフ２が同一の場合
    break;//ループを抜ける
  }
}