<!-- scv/resources/views/adminpolicy/edit.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>管理者パスワードポリシー設定</h3>
</div>

@if ($errors->any())
  <p style="color:red">
    @foreach ($errors->all() as $error)
      {{ $error }}<br>
    @endforeach
  </p>
@endif

@if (Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg') !!}</p>
@endif

<button onclick="location.href='/scvmanager/adminpolicy/show/{{$adminpolicy->id}}'">戻る</button>
{{ Form::open(['url' => '/scvmanager/adminpolicy/update', 'method' => 'post'] )}}
  <input type="hidden" name="id" value="{{$adminpolicy->id}}"/>
  <table class="table table-condensed table-bordered pwd-policy-wrap">
    <tr>
      <th>管理者パスワードポリシー適用先組織</th>
      <td>
        <p>{{$organization->name}}</p>
        <input type="hidden" value="{{$organization->organization_id}}"/>
      </td>
    </tr>
    <tr>
      <th>パスワードの最低文字数</th>
      <td>
        {{ Form::number('pwd_length', $adminpolicy->pwd_length, ['min' => 1, 'max' => $pwd_length_max]) }}文字
        <span id="adminpolicy-length"></span>
      </td>
    </tr>
      <th>パスワード変更の最低間隔</th>
      <td>
        {{ Form::number('pwd_min_term', $adminpolicy->pwd_min_term, ['min' => 0]) }}日間
        <span id="adminpolicy-min-term"></span>
      </td>
    </tr>
    <tr>
      <th>パスワードの有効期限</th>
      <td>
        {{ Form::number('pwd_max_term', $adminpolicy->pwd_max_term, ['min' => 0]) }}日間
        <span id="adminpolicy-max-term"></span>
      </td>
    </tr>
    <tr>
      <th>期限切れ警告の表示期間</th>
      <td>
        {{ Form::number('pwd_warning_term', $adminpolicy->pwd_warning_term, ['min' => 0]) }}日前から
        <span id="adminpolicy-warning-term"></span>
      </td>
    </tr>
    <tr>
      <th>重複チェックを行う世代数</th>
      <td>
        {{ Form::number('pwd_generation_limit', $adminpolicy->pwd_generation_limit, ['min' => 0, 'max' => $pwd_generation_limit_max]) }}件
        <span id="adminpolicy-generation-limit"></span>
        <span id="generation-warning" style="margin-left: 5px; color: red"></span>
      </td>
    </tr>
    <tr>
      <th>アカウントロックまでのログイン試行回数</th>
      <td>
        {{ Form::number('lock_limit', $adminpolicy->lock_limit, ['min' => 0, 'max' => 10]) }}回
        <span id="adminpolicy-lock-limit"></span>
      </td>
    </tr>
    <tr>
      <th>一定の複雑性を満たしたパスワードのみ許可する</th>
      <td>
        {{ Form::checkbox('pwd_complexity', 1 ,$adminpolicy->pwd_complexity) }}
        <span id="adminpolicy-complexity"></span>
      </td>
    </tr>
    <tr>
      <th>パスワードに含めることのできない単語</th>
      <td>
        {{ Form::textarea('pwd_ng_words', $adminpolicy->pwd_ng_words, ['placeholder' => "password\r\nabcd\r\n1234"]) }}<br>
        <span id="adminpolicy-ngwords"></span>
      </td>
    </tr>
  </table>
  {{ Form::submit('登録') }}
{{ Form::close() }}
@stop
