<!-- scv/resources/views/adminpolicy/index.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>管理者パスワードポリシー</h3>
</div>

<p>管理者パスワードポリシーを設定したい組織を選択してください</p>

@if (Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg') !!}</p>
@endif

@if ($errors->any())
  <p style="color:red">
    @foreach ($errors->all() as $error)
      {{ $error }}<br>
    @endforeach
  </p>
@endif

@if (Session::has('flash_msg'))
  <p style="color:red">{!! Session::get('flash_msg') !!}</p>
@endif

<button onclick="location.href='{{URL::to('/scvmanager/users')}}'">戻る</button>
<button onclick="location.href='{{URL::to('/scvmanager/adminpolicy/create')}}'">作成</button>

<div class="table-responsive">
  <table class="table table-condensed table-bordered table-striped">
    <tr>
      <th>組織名</th>
      <th>作成日</th>
      <th>更新日</th>
    </tr>
    @foreach($adminpolicies as $adminpolicy)
    <tr>
      <td><a href="adminpolicy/show/{{ $adminpolicy->id }}">{{ $adminpolicy->name }}</a></td>
      <td>{{ $adminpolicy->created_at }}</td>
      <td>{{ $adminpolicy->updated_at }}</td>
    </tr>
    @endforeach
  </table>
</div>

@stop

