<!-- scv/resources/views/adminpolicy/show.blade.php -->
@extends('layout.default')
@section('content')

<div class="page-header">
  <h3>管理者パスワードポリシー詳細</h3>
</div>

<button onclick="location.href='/scvmanager/adminpolicy'">戻る</button>
<button onclick="location.href='/scvmanager/adminpolicy/edit/{{ $adminpolicy->id }}'">編集</button>
<button onclick="location.href='/scvmanager/adminpolicy/delete/{{ $adminpolicy->id }}'">削除</button>

<div class="table-responsive">
  <table class="table table-condensed table-bordered pwd-policy-wrap">
    <tr>
      <th>組織名</th>
      <td>{{ $organization->name }}</td>
    </tr>
    <tr>
      <th>パスワードの最低文字数</th>
      <td>{{ $adminpolicy->pwd_length }} 文字</td>
    </tr>
    <tr>
      <th>パスワード変更の最低間隔</th>
      <td>{{ $adminpolicy->pwd_min_term }} 日間</td>
    </tr>
    <tr>
      <th>パスワードの有効期限</th>
      <td>{{ $adminpolicy->pwd_max_term }} 日間</td>
    </tr>
    <tr>
      <th>期限切れ警告の表示期間</th>
      <td>{{ $adminpolicy->pwd_warning_term }} 日前から</td>
    </tr>
    <tr>
      <th>重複チェックを行う世代数</th>
      <td>{{ $adminpolicy->pwd_generation_limit }} 件</td>
    </tr>
    <tr>
      <th>アカウントロックまでのログイン試行回数</th>
      <td>{{ $adminpolicy->lock_limit }} 回</td>
    </tr>
    <tr>
      <th>一定の複雑性を満たしたパスワードのみ許可する</th>
      <td>{{ $adminpolicy->pwd_complexity ? '有効' : '無効' }}</td>
    </tr>
    <tr>
      <th>パスワードに含めることのできない単語</th>
      <td><pre>{{ $adminpolicy->pwd_ng_words }}</pre></td>
    </tr>
  </table>
</div>
@stop
